#include <iostream>
#include <fstream>
#include <stdexcept>
using namespace std;

double rzut(int i, double* y,double t)
{
	static const double g = -9.81; //m/s^2

	double wynik = 0;
	switch(i)
	{
	case 0:
		wynik = y[1];
		break;
	case 1:
		wynik = -g;
		break;
	default:
		throw runtime_error("Zly numer rownania");
	}

	return wynik;
}

double oscylator(int i, double* y,double t)
{
	static const double k = 1;

	double wynik = 0;
	switch(i)
	{
	case 0:
		wynik = y[1];
		break;
	case 1:
		wynik = -y[0];
		break;
	default:
		throw runtime_error("Zly numer rownania");
	}

	return wynik;
}

//solver
double* odeint_Euler(int N, double(*f)(int, double*,double), double* y, double t, double h, double* y_nast)
{
	for(int i = 0; i<N; ++i) y_nast[i] = y[i] + h * f(i, y, t);
	return y_nast;
}

double* odeint_MidPoint(int N, double(*f)(int, double*,double), double* y, double t, double h, double* y_nast)
{
	double* y_tmp = new double[N];
	for(int i = 0; i<N; ++i)
	{
		double k1 = h * f(i,y,t);
		y_tmp[i] = y[i] + 0.5*k1;
	}
	for(int i = 0; i<N; ++i)
	{
		double k2 = h * f(i,y_tmp,t + 0.5*h);
		y_nast[i] = y[i] + k2;
	}
	delete [] y_tmp;
	return y_nast;
}

int main()
{
	cout << "ODE Int (c) UMK 2017\n";

	int N = 2;
	double* y = new double[N];
	double* y_nast = new double[N];

	//warunki poczatkowe
	y[0] = 0;
	y[1] = 1;
	y_nast[0] = 0;
	y_nast[1] = 0;

	const double tmax = 1000; //10s
	const double h = 0.01;

	for(double t = 0; t < tmax; t+=h)
	{
		//propagacja
		//odeint_Euler(N,rzut,y,t,h,y_nast);
		//odeint_Euler(N,oscylator,y,t,h,y_nast);
		odeint_MidPoint(N,oscylator,y,t,h,y_nast);

		cout << t << "\t" << y[0] << "\t" << y[1] << "\n";

		//zamiana tablic miejscami
		double* y_tmp = y;
		y = y_nast;
		y_nast = y_tmp;
	}

	delete [] y;
	delete [] y_nast;

	cout << "\n\nOK.\n\n";

	return 0;
}