#include "PunktMaterialny.h"
#include <stddef.h>

void PunktMaterialny::_PunktMaterialny(double pooenie, double prdko, double masa)	
{
	numerKroku = 0;
	this->pooenie = pooenie;
	this->poprzedniePooenie = pooenie;
	this->prdko = prdko;
	this->masa = masa;
}

PunktMaterialny::PunktMaterialny(double pooenie, double prdko, double masa)
	:czyPierwszyKrok(true)
{
	_PunktMaterialny(pooenie, prdko, masa);
}

PunktMaterialny::PunktMaterialny()
{
	_PunktMaterialny(0, 0, 1);
}

double PunktMaterialny::Pooenie() const
{
	return pooenie;
}

double PunktMaterialny::PoprzedniePooenie() const
{
	return poprzedniePooenie;
}

double PunktMaterialny::NastpnePooenie() const
{
	return nastpnePooenie;
}

double PunktMaterialny::Prdko() const
{
	return prdko;
}

double PunktMaterialny::Masa() const
{
	return masa;
}

void PunktMaterialny::UstawPooenie(double pooenie)
{
	this->pooenie = pooenie;
	UstawPoprzedniePooenie(pooenie);
}

void PunktMaterialny::UstawPoprzedniePooenie(double poprzedniePooenie)
{
	this->poprzedniePooenie = pooenie;
}

void PunktMaterialny::UstawPrdko(double prdko)
{
	this->prdko = prdko;
}

void PunktMaterialny::UstawMas(double masa)
{
	this->masa = masa;
}

int PunktMaterialny::NumerKroku()
{
	return numerKroku;
}

void PunktMaterialny::PrzygotujRuch_Euler(double przyspieszenie, double krokCzasowy)
{
	nastpnaPrdko = prdko + przyspieszenie * krokCzasowy;
	nastpnePooenie = pooenie + prdko * krokCzasowy;
}

void PunktMaterialny::PrzygotujRuch_EulerPoprawiony(double przyspieszenie, double krokCzasowy)
{
	nastpnaPrdko = prdko + przyspieszenie * krokCzasowy;
	nastpnePooenie = pooenie + nastpnaPrdko * krokCzasowy;
}

void PunktMaterialny::PrzygotujRuch_Verlet(double przyspieszenie, double krokCzasowy)
{	
	if (czyPierwszyKrok)
	{
		PrzygotujRuch_EulerPoprawiony(przyspieszenie, krokCzasowy);
	}
	else
	{
		nastpnePooenie = -poprzedniePooenie + 2 * pooenie + przyspieszenie*krokCzasowy*krokCzasowy;
		nastpnaPrdko = (nastpnePooenie - poprzedniePooenie) / (2 * krokCzasowy); //oszustwo
	}
	czyPierwszyKrok = false;
}

void PunktMaterialny::PrzygotujRuch(double sia, double krokCzasowy, Algorytm algorytm)
{
	double przyspieszenie = sia / masa;
	switch (algorytm)
	{
	case algorytmEulera:
		PrzygotujRuch_Euler(przyspieszenie, krokCzasowy);
		break;
	case algorytmEuleraPoprawiony:
		PrzygotujRuch_EulerPoprawiony(przyspieszenie, krokCzasowy);
		break;
	case algorytmVerleta:
		PrzygotujRuch_Verlet(przyspieszenie, krokCzasowy);
		break;
	}
}

void PunktMaterialny::WykonajRuch()
{
	poprzedniePooenie = pooenie;
	pooenie = nastpnePooenie;
	prdko = nastpnaPrdko;
	++numerKroku;
}

//-----------------------------------

/*
class ZbirPunktwMaterialnych //meneder
{
protected:
int liczba;
PunktMaterialny* punkty;

virtual double Sia(int indeks) const = 0;
virtual void PrzedKrokiemNaprzd(double krokCzasowy){};
virtual void PoPrzygotowaniuRuchu(double krokCzasowy){};
virtual void PoKrokuNaprzd(double krokCzasowy){};

virtual void PrzygotujRuch(double krokCzasowy, Algorytm algorytm);
void WykonajRuch();

public:
ZbirPunktwMaterialnych(int liczba);
virtual ~ZbirPunktwMaterialnych();
void KrokNaprzd(double krokCzasowy, Algorytm algorytm);

protected:
void ZerujPrdkoredni();
};
*/

ZbirPunktwMaterialnych::ZbirPunktwMaterialnych(int liczba)
{
	this->liczba = liczba;
	punkty = new PunktMaterialny[liczba];
}

ZbirPunktwMaterialnych::~ZbirPunktwMaterialnych()
{	
	delete [] punkty;
}

void ZbirPunktwMaterialnych::PrzygotujRuch(double krokCzasowy, Algorytm algorytm)
{
	for (int i = 0; i < liczba; ++i)
		punkty[i].PrzygotujRuch(Sia(i), krokCzasowy, algorytm);
}

void ZbirPunktwMaterialnych::WykonajRuch()
{
	for (int i = 0; i < liczba; ++i)
		punkty[i].WykonajRuch();
}

void ZbirPunktwMaterialnych::KrokNaprzd(double krokCzasowy, Algorytm algorytm)
{
	PrzedKrokiemNaprzd(krokCzasowy);
	PrzygotujRuch(krokCzasowy, algorytm);
	PoPrzygotowaniuRuchu(krokCzasowy);
	WykonajRuch();
	PoKrokuNaprzd(krokCzasowy);
}

PunktMaterialny* ZbirPunktwMaterialnych::PobierzPunktMaterialny(int indeks) const
{
	if (indeks < 0 || indeks >= liczba) return NULL;
	else return &punkty[indeks];
}

double ZbirPunktwMaterialnych::rodekMasy()
{
	double rodekMasy = 0;
	double masaCakowita = 0;
	for (int i = 0; i < liczba; ++i){
		PunktMaterialny* p = PobierzPunktMaterialny(i);
			if (p != NULL){
				rodekMasy += p->Pooenie()*p->Masa();
				masaCakowita += p->Masa();
				
			}
	}
	rodekMasy /= masaCakowita;
	return rodekMasy;
}

double ZbirPunktwMaterialnych::redniaPrdko()
{
	double redniaPrdko = 0;
	for (int i = 0; i < liczba; ++i)	
		redniaPrdko += punkty[i].Prdko();
	redniaPrdko /= liczba;
	return redniaPrdko;
}

void ZbirPunktwMaterialnych::ZerujPrdkoredni()
{
	double redniaPrdko = redniaPrdko();
	for (int i = 0; i < liczba; ++i)
		punkty[i].UstawPrdko(punkty[i].Prdko() - redniaPrdko);
}
