#include <iostream>
#include <fstream>
#include <stdexcept>

const int N = 10;

#include "Numeryka.h"
#include "Fizyka.h"

int main()
{
	double* y = new double[N];
	double* y_nast = new double[N];
	for (int i = 0; i < N; ++i)
	{
		y[i] = 0;
		y_nast[i] = 0;
	}

	//polozenia
	y[0] = 0;
	y[2] = 1;
	y[4] = 2;
	y[6] = 3;
	y[8] = 4;

	//predkosci
	y[1] = 1;
	y[9] = -1;

	const double tmax = 100;
	const double h = 0.01;

	std::ofstream plik_wy("wyniki.dat");
	plik_wy.precision(10);
	plik_wy.setf(std::ios::scientific);

	for (double t = 0; t < tmax; t += h)
	{
		//odeint_Euler<double>(N, rzut, y, t, h, y_nast);
		//odeint_MidPoint<double>(N, rzut, y, t, h, y_nast);
		//odeint_Euler<double>(N, oscylator_harmoniczny, y, t, h, y_nast);
		//odeint_MidPoint<double>(N, oscylator_harmoniczny, y, t, h, y_nast);
		//odeint_RK4<double>(N, oscylator_harmoniczny, y, t, h, y_nast);
		
		//odeint_MidPoint<double>(N, oscylatory_sprzezone, y, t, h, y_nast);
		odeint_RK4<double>(N, oscylatory_sprzezone<double>, y, t, h, y_nast);
		

		//std::cout << t << "\t" << y[0] << "\t" << y[1] << "\n";

		plik_wy << t << "\t";
		for(int i=0;i<N;++i) plik_wy << y[i] << "\t";
		plik_wy << "\n";

		//ze rozwizanie
		//for (int i = 0; i < N; ++i) y[i] = y_nast[i];

		//dobre rozwizanie
		std::swap(y, y_nast);
	}

	delete[] y;
	delete[] y_nast;

	plik_wy.close();

	std::cout << "OK.";

	//system("pause");
}