#include "sampleboxgame.h"

SampleBoxGame::SampleBoxGame()
{
}

void SampleBoxGame::initialize()
{
	SampleGame::initialize();

	//dodaj material, ksztalt, pozycje, orientacje i aktora
	//stworz plaszczyzne i box w PhysX

	//material
	PxMaterial* material = physics->createMaterial(0.8f, 0.7f, 0.1f);

	//plaszczyzne
	PxTransform pose = PxTransform(PxVec3(0), PxQuat(PxHalfPi, PxVec3(0,0,1)));
	PxRigidStatic* plane = physics->createRigidStatic(pose);
	PxShape* shape = plane->createShape(PxPlaneGeometry(), *material);
	scene->addActor(*plane);

	//pudelko
	pose = PxTransform(PxVec3(0,23.5f,0), PxQuat(PxHalfPi*0.2f, PxVec3(0,0,1)));
	boxActor = physics->createRigidDynamic(pose);
	boxActor->createShape(PxBoxGeometry(1.0f, 1.0f, 1.0f), *material);
	PxRigidBodyExt::setMassAndUpdateInertia(*boxActor, 100.0f); 
	scene->addActor(*boxActor);

	boxMesh = MeshHelper::createBox(graphics);
	planeMesh = MeshHelper::createGrid(graphics, 20, 40);

	camera->lookAt(PxVec3(0, 30, 30), PxVec3(0,5,0));
}

void SampleBoxGame::release()
{
	SampleGame::release();
}

void SampleBoxGame::input(GxF32 elapsedTime)
{
	SampleGame::input(elapsedTime);
}

void SampleBoxGame::update(GxF32 elapsedTime)
{
	SampleGame::update(elapsedTime);
}

void SampleBoxGame::render(GxF32 elapsedTime)
{
	SampleGame::render(elapsedTime);

	graphics->clear(Color::CornflowerBlue);

	effect->bind();
	effect->setProjMatrix(projectionMtx);
	effect->setViewMatrix(camera->getViewMatrix());

	effect->setModelMatrix(MathHelper::createIdentity());
	graphics->renderMesh(effect, planeMesh);

	//uzyj pozycji do ustawienia szescianu

	//rysuj  pudelko
	PxTransform pose = boxActor->getGlobalPose();
	effect->setModelMatrix(PxMat44(pose));
	graphics->renderMesh(effect, boxMesh, Material::Ruby);

	effect->unbind();
}