#pragma once

#ifndef __sampleboxgame_h__
	#define __sampleboxgame_h__

#include <samplegame.h>

class SampleJointsGame : public SampleGame
{
public:
	SampleJointsGame();

	virtual void initialize();
	virtual void release();
	virtual void input(GxF32 elapsedTime);
	virtual void update(GxF32 elapsedTime);
	virtual void render(GxF32 elapsedTime);

	virtual void customizeScene(PxSceneDesc& desc);

	void createBreakableWall(const PxTransform& transform);
	void createRope(const PxTransform& transform);	

	virtual void printHelp();

protected:
	PxRigidStatic* planeActor;
	PxRigidStatic* girderActor;
	Material planeGraphicsMaterial;
	Material brickGraphicsMaterial;

	std::vector<PxJoint*> joints;
};

#endif /* __sampleboxgame_h__ */