#pragma once

#ifndef __gx_vertextype_h__
	#define __gx_vertextype_h__

#include "foundation.h"
#include "gxopengl.h"
#include "foundation/PxVec2.h"
#include "foundation/PxVec3.h"
#include "foundation/PxVec4.h"

using namespace physx;

namespace Gx
{
	struct VertexAttribute;

	struct GX_API VertexPosition
	{
		VertexPosition(const PxVec3& position) : position(position) { }

		PxVec3 position;

		static const GLuint VertexAttributesCount = 1; // mona to pobra _countof(VertexAttributes)
		static const VertexAttribute VertexAttributes[VertexAttributesCount];
	};

	struct GX_API VertexPositionColor
	{
		VertexPositionColor(const PxVec3& position, const PxVec4& color)
			: position(position), color(color) { }

		PxVec3 position;
		PxVec4 color;

		static const GLuint VertexAttributesCount = 2;
		static const VertexAttribute VertexAttributes[VertexAttributesCount];
	};

	struct GX_API VertexPositionTexture
	{
		VertexPositionTexture(const PxVec3& position, const PxVec3& texcoord)
			: position(position), texcoord(texcoord) { }

		PxVec3 position;
		PxVec3 texcoord;

		static const GLuint VertexAttributesCount = 2;
		static const VertexAttribute VertexAttributes[VertexAttributesCount];
	};

	struct GX_API VertexPositionNormal
	{
		VertexPositionNormal(const PxVec3& position, const PxVec3& normal)
			: position(position), normal(normal) { }

		PxVec3 position;
		PxVec3 normal;

		static const GLuint VertexAttributesCount = 2;
		static const VertexAttribute VertexAttributes[VertexAttributesCount];
	};

	struct GX_API VertexPositionColorTexture
	{
		VertexPositionColorTexture(const PxVec3& position, const PxVec4& color, const PxVec3& texcoord)
			: position(position), color(color), texcoord(texcoord) { }

		PxVec3 position;
		PxVec4 color;
		PxVec3 texcoord;

		static const GLuint VertexAttributesCount = 3;
		static const VertexAttribute VertexAttributes[VertexAttributesCount];
	};

	struct GX_API VertexPositionNormalTexture
	{
		VertexPositionNormalTexture(const PxVec3& position, const PxVec3& normal, const PxVec3& texcoord)
			: position(position), normal(normal), texcoord(texcoord) { }

		PxVec3 position;
		PxVec3 normal;
		PxVec3 texcoord;

		static const GLuint VertexAttributesCount = 3;
		static const VertexAttribute VertexAttributes[VertexAttributesCount];
	};
}

#endif /* __gx_vertextype_h__ */