// Piatek2.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <stdexcept>
#include <iostream>
#include <fstream>
using namespace std;

//fizyka
double rzut(int i,double* y,double t)
{
	const double g=9.81;

	switch(i)
	{
	case 0:
		return y[1];
	case 1:
		return g;
	default:
		throw runtime_error("Zy numer indeksu");
	}
}

//fizyka
double oscylator(int i,double* y,double t)
{
	double w=1;

	switch(i)
	{
	case 0:
		return y[1];
	case 1:
		return -w*w*y[0];
	default:
		throw runtime_error("Zy numer indeksu");
	}
}

//numeryka
void odeint_Euler(int N,double (*f)(int i,double* y,double t),double* y,double t,double h,/*out*/double* y_nast)
{
	for(int i=0;i<N;++i) y_nast[i]=y[i]+h*f(i,y,t);
}

void odeint_MidPoint(int N,double (*f)(int i,double* y,double t),double* y,double t,double h,/*out*/double* y_nast)
{
	double* y_tmp=new double[N];
	for(int i=0;i<N;++i)
	{
		double k1=h*f(i,y,t);
		y_tmp[i]=y[i]+0.5*k1;
	}
	for(int i=0;i<N;++i)
	{
		double k2=h*f(i,y_tmp,t+0.5*h);
		y_nast[i]=y[i]+k2;
	}
	delete [] y_tmp;
}

/*
template<typename T>
void odeint_Euler(int N,T (*f)(int i,T* y,T t),T* y,T t,T h,T* y_nast)
{
	for(int i=0;i<N;++i) y_nast[i]=y[i]+h*f(i,y,t);
}
*/

int _tmain(int argc, _TCHAR* argv[])
{
	const int N=2;
	double tmax = 10;
	double h = 0.001;
	double* y=new double[N];
	double* y_nast=new double[N];
	for(int i=0;i<N;++i)
	{
		y[i]=0.0;
		y_nast[i]=0.0;
	}
	y[0]=1;

	ofstream plik_wy("wyniki.dat");
	plik_wy.precision(10);
	plik_wy.setf(ios::scientific);

	for(double t=0;t<tmax;t+=h)
	{
#ifdef _DEBUG
		cout << "t=" << t << ", x=" << y[0] << ", vx=" << y[1] << "\n";
#endif
		plik_wy << t << "\t" << y[0] << "\t" << y[1] << "\n";

		//odeint_Euler(N,rzut,y,t,h,y_nast);
		//odeint_MidPoint(N,rzut,y,t,h,y_nast);

		odeint_MidPoint(N,oscylator,y,t,h,y_nast);
		//odeint_Euler(N,oscylator,y,t,h,y_nast);

		//brzydkie
		for(int i=0;i<N;++i) y[i]=y_nast[i];
	}

	plik_wy.close();

	cout << "OK.\n\n";

	return 0;
}

