// FizykaWGrze.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <stdexcept> //wyjatki
#include <iostream> //<< >>
#include <fstream> //plik
using namespace std;

//fizyka
double rzut(int i,double* y,double t) //co drugi indeks to sila
{
	static const double g=9.81; //jednostka m/s^2

	double wynik=0;
	switch(i)
	{
	case 0:
		wynik=y[1]; //pochodna polozenia = predkosc
		break;
	case 1:
		wynik=g; //pochodna predkosci = sia
		break;
	default:
		throw std::runtime_error("Zy numer rwnania");
	}
	return wynik;
}

double oscylacje(int i,double* y,double t) //co drugi indeks to sila
{
	static const double w=1;

	double wynik=0;
	switch(i)
	{
	case 0:
		wynik=y[1]; //pochodna polozenia = predkosc
		break;
	case 1:
		wynik=-w*w*y[0]; //pochodna predkosci = sia
		break;
	default:
		throw std::runtime_error("Zy numer rwnania");
	}
	return wynik;
}

//met. num.
//RK1
double* odeint_Euler(int N,double (*f)(int,double*,double),double* y,double t,double h,double* y_nast)
{
	for(int i=0;i<N;++i) y_nast[i]=y[i]+h*f(i,y,t);
	return y_nast;
}

//RK2
double* odeint_MidPoint(int N,double (*f)(int,double*,double),double* y,double t,double h,double* y_nast)
{
	double* y_tmp=new double[N];
	for(int i=0;i<N;++i)
	{
		double k1=h*f(i,y,t);
		y_tmp[i]=y[i]+0.5*k1;
	}
	for(int i=0;i<N;++i)
	{
		double k2=h*f(i,y_tmp,t+0.5*h);
		y_nast[i]=y[i]+k2;
	}
	delete [] y_tmp;
	return y_nast;
}

double* odeint_RK4(int N,double (*f)(int,double*,double),double* y,double t,double h,double* y_nast)
{
	double* y_tmp=new double[N];
	double* k1=new double[N];
	double* k2=new double[N];
	double* k3=new double[N];
	double* k4=new double[N];
	for(int i=0;i<N;++i)
	{
		k1[i]=h*f(i,y,t);
		y_tmp[i]=y[i]+0.5*k1[i];
	}
	for(int i=0;i<N;++i)
	{
		k2[i]=h*f(i,y_tmp,t+0.5*h);
		y_nast[i]=y[i]+0.5*k2[i];
	}
	for(int i=0;i<N;++i)
	{
		k3[i]=h*f(i,y_nast,t+0.5*h);
		y_tmp[i]=y[i]+k3[i];
	}
	for(int i=0;i<N;++i)
	{
		k4[i]=h*f(i,y_tmp,t+h);
		y_nast[i]=y[i]+(k1[i]+2.0*k2[i]+2.0*k3[i]+k4[i])/6.0;
	}
	delete [] y_tmp;
	delete [] k1;
	delete [] k2;
	delete [] k3;
	delete [] k4;
	return y_nast;
}

double* odeint_RK4F5(int N,double (*f)(int,double*,double),double* y,double t,/*out*/double& h,double* y_nast)
{
	static const double b31=3.0/32.0; 
	static const double b32=9.0/32.0; 
	static const double a3=3.0/8.0;
	
	static const double b41=1932.0/2197.0; 
	static const double b42=-7200.0/2197.0; 
	static const double b43=7296.0/2197.0; 
	static const double a4=12.0/13.0;
	
	static const double b51=439.0/216.0; 
	static const double b53=3680.0/513.0; 
	static const double b54=-845.0/4104.0;
	
	static const double w41=25.0/216.0; 
	static const double w43=1408.0/2565.0; 
	static const double w44=2197.0/4104.0;
	
	static const double b61=-8.0/27.0; 
	static const double b63=-3544.0/2565.0; 
	static const double b64=1859.0/4104.0; 
	static const double b65=-11.0/40.0;

	static const double w51=16.0/135.0; 
	static const double w53=6656.0/12825.0; 
	static const double w54=28561.0/56430.0; 
	static const double w55=-9.0/50.0; 
	static const double w56=2.0/55.0;

	double* y_tmp=new double[N];
	double* y4_nast=new double[N];
	double* k1=new double[N];
	double* k2=new double[N];
	double* k3=new double[N];
	double* k4=new double[N];
	double* k5=new double[N];
	double* k6=new double[N];
	double blad = 0;
	const double blad_max=1E-10;
	const double blad_min=1E-11;

	do
	{
		for(int i=0;i<N;++i)
		{
			k1[i]=h*f(i,y,t);
			y_tmp[i]=y[i]+0.25*k1[i];
		}
		for(int i=0;i<N;++i)
		{
			k2[i]=h*f(i,y_tmp,t+0.25*h);
			y_nast[i]=y[i]+b31*k1[i]+b32*k2[i];
		}
		for(int i=0;i<N;++i)
		{
			k3[i]=h*f(i,y_nast,t+a3*h);
			y_tmp[i]=y[i]+b41*k1[i]+b42*k2[i]+b43*k3[i];
		}
		for(int i=0;i<N;++i)
		{
			k4[i]=h*f(i,y_tmp,t+a4*h);
			y_nast[i]=y[i]+b51*k1[i]-8.0*k2[i]+b53*k3[i]+b54*k4[i];
		}
		for(int i=0;i<N;++i)
		{
			k5[i]=h*f(i,y_nast,t+h);
			y4_nast[i]=y[i]+w41*k1[i]+w43*k3[i]+w44*k4[i]-0.2*k5[i]; //RK4 (5 wyrazow)
			y_tmp[i]=y[i]+b61*k1[i]+2.0*k2[i]+b63*k3[i]+b64*k4[i]+b65*k5[i];
		}
		blad=0;
		for(int i=0;i<N;++i)
		{
			k6[i]=h*f(i,y_tmp,t+0.5*h);
			y_nast[i]=y[i]+w51*k1[i]+w53*k3[i]+w54*k4[i]+w55*k5[i]+w56*k6[i]; //RK5 (6 wyrazow)
			blad+=fabs(y_nast[i]-y4_nast[i]);
		}
		
#ifdef _DEBUG
		cout << "blad=" << blad << ", h=" << h << "\n";
#endif
		if(blad<blad_min) h*=2;
		if(blad>blad_max) h/=2;
	}
	while(blad<blad_min || blad>blad_max);

	delete [] y_tmp;
	delete [] y4_nast;
	delete [] k1;
	delete [] k2;
	delete [] k3;
	delete [] k4;
	delete [] k5;
	delete [] k6;

	return y_nast;
}

int _tmain(int argc, _TCHAR* argv[])
{
	int N=2; //1D

	double* y=new double[N]; //C++
	double* y_nast=new double[N];
	for(int i=0;i<N;++i)
	{
		y[i]=0;
		y_nast[i]=0;
	}
	y[0]=1;
	
	const double tmax=30;
	double h=0.1;

	ofstream plik_wy("wyniki.dat"); //C++(?)
	plik_wy.precision(10);
	plik_wy.setf(ios::scientific);

	for(double t=0;t<tmax;t+=h)
	{
		//odeint_Euler(N,rzut,y,t,h,y_nast);
		//odeint_MidPoint(N,rzut,y,t,h,y_nast);
		//odeint_Euler(N,oscylacje,y,t,h,y_nast);
		//odeint_MidPoint(N,oscylacje,y,t,h,y_nast);
		//odeint_RK4(N,oscylacje,y,t,h,y_nast);
		odeint_RK4F5(N,oscylacje,y,t,h,y_nast);

		#ifdef _DEBUG 
		cout << "t=" << t << "\ty[0]=" << y[0] << "\ty[1]=" << y[1] << "\n";
		#endif
		plik_wy << t << "\t" << y[0] << "\t" << y[1] << "\t" << h << "\n";


		/*
		//brzydko = metoda brute force
		double tmp=0;
		for(int i=0;i<N;++i)
		{
			tmp=y[i];
			y[i]=y_nast[i];
			y_nast[i]=tmp;
		}
		*/

		//zamiana buforow
		double* y_tmp=y;
		y=y_nast;
		y_nast=y_tmp;
	}

	plik_wy.close();	

	delete [] y_nast; //C++
	delete [] y; 

	cout << "OK.\n\n";

	return 0;
}

