// FizykaWGrze.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <stdexcept> //wyjatki
#include <iostream> //<< >>
#include <fstream> //plik
using namespace std;

double rzut(int i,double* y,double t) //co drugi indeks to sila
{
	static const double g=9.81; //jednostka m/s^2

	double wynik=0;
	switch(i)
	{
	case 0:
		wynik=y[1]; //pochodna polozenia = predkosc
		break;
	case 1:
		wynik=g; //pochodna predkosci = sia
		break;
	default:
		throw std::runtime_error("Zy numer rwnania");
	}
	return wynik;
}

double* odeint_Euler(int N,double (*f)(int,double*,double),double* y,double t,double h,double* y_nast)
{
	for(int i=0;i<N;++i) y_nast[i]=y[i]+h*f(i,y,t);
	return y_nast;
}

double* odeint_MidPoint(int N,double (*f)(int,double*,double),double* y,double t,double h,double* y_nast)
{
	double* y_tmp=new double[N];
	for(int i=0;i<N;++i)
	{
		double k1=h*f(i,y,t);
		y_tmp[i]=y[i]+0.5*k1;
	}
	for(int i=0;i<N;++i)
	{
		double k2=h*f(i,y_tmp,t+0.5*h);
		y_nast[i]=y[i]+k2;
	}
	delete [] y_tmp;
	return y_nast;
}

int _tmain(int argc, _TCHAR* argv[])
{
	int N=2; //1D

	double* y=new double[N]; //C++
	double* y_nast=new double[N];
	for(int i=0;i<N;++i)
	{
		y[i]=0;
		y_nast[i]=0;
	}
	
	const double tmax=10;
	const double h=0.1;

	ofstream plik_wy("wyniki.dat"); //C++(?)
	plik_wy.precision(10);
	plik_wy.setf(ios::scientific);

	for(double t=0;t<tmax;t+=h)
	{
		//odeint_Euler(N,rzut,y,t,h,y_nast);
		odeint_MidPoint(N,rzut,y,t,h,y_nast);
#ifdef _DEBUG 
		cout << "t=" << t << "\ty[0]=" << y[0] << "\ty[1]=" << y[1] << "\n";
#endif
		plik_wy << t << "\t" << y[0] << "\t" << y[1] << "\n";

		/*
		//brzydko = metoda brute force
		double tmp=0;
		for(int i=0;i<N;++i)
		{
			tmp=y[i];
			y[i]=y_nast[i];
			y_nast[i]=tmp;
		}
		*/

		//zamiana buforow
		double* y_tmp=y;
		y=y_nast;
		y_nast=y_tmp;
	}

	plik_wy.close();	

	delete [] y_nast; //C++
	delete [] y; 

	cout << "OK.\n\n";

	return 0;
}

