// Poniedzialek.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <stdexcept> //runtime_error
#include <iostream> //cout
#include <fstream> //ofstream
using namespace std;

//fizyke
double rzut(int i,double* y,double t) //1D
{
	static const double g=9.81; //m/s^2

	switch(i)
	{
	case 0:
		return y[1];
	case 1:
		return g;
	default:
		throw runtime_error("Bdny indeks rwnania");
	}
}

double oscylator(int i,double* y,double t) //1D
{
	static const double w=1;

	switch(i)
	{
	case 0:
		return y[1];
	case 1:
		return -w*w*y[0];
	default:
		throw runtime_error("Bdny indeks rwnania");
	}
}

//numeryka
double* odeint_Euler(int N,double (*f)(int i,double* y,double t),double* y,double t,double h,double* y_nast)
{
	for(int i=0;i<N;++i)
		y_nast[i]=y[i]+h*f(i,y,t);

	return y_nast;
}

double* odeint_MidPoint(int N,double (*f)(int i,double* y,double t),double* y,double t,double h,double* y_nast)
{
	double* y_mp=new double[N];
	for(int i=0;i<N;++i)
	{
		double k1=h*f(i,y,t);
		y_mp[i]=y[i]+0.5*k1;
	}
	for(int i=0;i<N;++i)
	{
		double k2=h*f(i,y_mp,t+0.5*h);
		y_nast[i]=y[i]+k2;
	}
	delete [] y_mp;
	return y_nast;
}

/*
template<typename T>
T* odeint_MidPoint(int N,T (*f)(int i,T* y,T t),T* y,T t,T h,T* y_nast)
{
	T* y_mp=new T[N];
	for(int i=0;i<N;++i)
	{
		T k1=h*f(i,y,t);
		y_mp[i]=y[i]+0.5*k1;
	}
	for(int i=0;i<N;++i)
	{
		T k2=h*f(i,y_mp,t+0.5*h);
		y_nast[i]=y[i]+k2;
	}
	delete [] y_mp;
	return y_nast;
}
*/

int main(int argc, char* argv[])
//int _tmain(int argc, _TCHAR* argv[])
{
	const int N=2;
	double* y=new double[N];
	double* y_nast=new double[N];
	for(int i=0;i<N;i++)
	{
		y[i]=0;
		y_nast[i]=0;
	}
	y[0]=1;
	const double h=0.001;
	const double tmax=10;

	ofstream plik_wy("wyniki.dat");
	plik_wy.precision(10);
	plik_wy.setf(ios::scientific);

	for(double t=0;t<tmax;t+=h)
	{
#ifdef _DEBUG
		cout << "t=" << t << ", x=" << y[0] << ", v=" << y[1] << "\n";
#endif
		plik_wy << t << "\t" << y[0] << "\t" << y[1] << "\n";

		//odeint_Euler(N,rzut,y,t,h,y_nast);
		//odeint_MidPoint(N,rzut,y,t,h,y_nast);
		odeint_MidPoint(N,oscylator,y,t,h,y_nast);

		/*
		//nadmiarowe - nieeleganckie
		for(int i=0;i<N;++i)
		{
			double y_tmp=y[i];
			y[i]=y_nast[i];
			y_nast[i]=y_tmp;
		}
		*/

		double* py_tmp=y;
		y=y_nast;
		y_nast=py_tmp;
	}

	plik_wy.close();

	delete [] y;
	delete [] y_nast;

	cout << "OK.\n\n";

	return 0;
}

