﻿using System;
using System.Collections.Generic;
//using System.Linq;
using System.Text;

//Projekt jest zgodny z językiem C# w wersji 2.0 
//(wymuszona zgodnosc z .NET Framework 2.0 w opcjach projektu)

//using T = System.Double;

using System.IO;

namespace odeint
{
    class Program
    {
        const bool komunikatyNaEkranie = false;

        const double blad_min = 1E-11;
        const double blad_max = 1E-10;

        #region Równania
        static double rzut(int i,double[] y,double t)
        //rzut swobodny: y[0]=x, y[1]=v
        {
            const double g=-9.81;

            double wynik=0;
            switch(i)
            {
                case 0:
                        wynik=y[1];
                        break;
                case 1:
                        wynik=g;
                        break;

                default:
                        throw new Exception("Zly numer rownania");
            }

            return wynik;
        }

        static double oscylacje(int i,double[] y,double t)
        //sila harmoniczna: y[0]=x, y[1]=v
        {
            const double w=1;
            const double b=0;

            double wynik=0;
            switch(i)
            {
                case 0:
                        wynik=y[1];
                        break;
                case 1:
                        wynik=-w*w*y[0]-2*b*y[1];
                        break;

                default:
                        throw new Exception("Zly numer rownania");
            }

            return wynik;
        }
        #endregion

        #region Metody całkujące układ równań różniczkowych zwyczajnych pierwszego rzędu
        delegate double funkcja(int i,double[] y,double t);

        static void odeint_Euler(int N,funkcja f,double[] y,double t,double h,double[] y_nast)
        {
            for(int i=0;i<N;++i) y_nast[i]=y[i]+h*f(i,y,t);
        }        

        static void odeint_MidPoint(int N,funkcja f,double[] y,double t,double h,double[] y_nast) //RK2, ulepszony Euler
        {
            double[] y_tmp=new double[N];
            for(int i=0;i<N;++i)
            {
                double k1=h*f(i,y,t);
                y_tmp[i]=y[i]+0.5*k1;
            }
            for(int i=0;i<N;++i)
            {
                double k2=h*f(i,y_tmp,t+0.5*h);
                y_nast[i]=y[i]+k2;
            }
        }

        static void odeint_RK4(int N,funkcja f,double[] y,double t,double h,double[] y_nast)
        {
            double[] y_tmp=new double[N];
            double[] k1=new double[N];
            double[] k2=new double[N];
            double[] k3=new double[N];
            double[] k4=new double[N];
            for(int i=0;i<N;++i)
            {
                k1[i]=h*f(i,y,t);
                y_tmp[i]=y[i]+0.5*k1[i];
            }
            for(int i=0;i<N;++i)
            {
                k2[i]=h*f(i,y_tmp,t+0.5*h);
                y_tmp[i]=y[i]+0.5*k2[i];
            }
            for(int i=0;i<N;++i)
            {
                k3[i]=h*f(i,y_tmp,t+0.5*h);
                y_tmp[i]=y[i]+k3[i];
            }
            for(int i=0;i<N;++i)
            {
                k4[i]=h*f(i,y_tmp,t+h);
                y_nast[i]=y[i]+(k1[i]+2.0*k2[i]+2.0*k3[i]+k4[i])/6.0;
            }
        }

        static void odeint_RKF45(int N,funkcja f,double[] y,double t,ref double h,double[] y_nast)        
        {
            const double b31=3.0/32.0; const double b32=9.0/32.0; const double a3=3.0/8.0;
            const double b41=1932.0/2197.0; const double b42=-7200.0/2197.0; const double b43=7296.0/2197.0; const double a4=12.0/13.0;
            const double b51=439.0/216.0; const double b53=3680.0/513.0; const double b54=-845.0/4104.0;
            const double w41=25.0/216.0; const double w43=1408.0/2565.0; const double w44=2197.0/4104.0;
    
            const double b61=-8.0/27.0; const double b63=-3544.0/2565.0; const double b64=1859.0/4104.0; const double b65=-11.0/40.0;
            const double w51=16.0/135.0; const double w53=6656.0/12825.0; const double w54=28561.0/56430.0; const double w55=-9.0/50.0; const double w56=2.0/55.0;

            double[] y_tmp=new double[N];
            double[] y4_nast=new double[N]; //y5_nast->y_nast
            double[] k1=new double[N];
            double[] k2=new double[N];
            double[] k3=new double[N];
            double[] k4=new double[N];
            double[] k5=new double[N];
            double[] k6=new double[N];

            double blad=0;
            do
            {
                for(int i=0;i<N;++i)
                {
                    k1[i]=h*f(i,y,t);
                    y_tmp[i]=y[i]+0.25*k1[i];
                }
                for(int i=0;i<N;++i)
                {
                    k2[i]=h*f(i,y_tmp,t+0.25*h);
                    y_tmp[i]=y[i]+b31*k1[i]+b32*k2[i];
                }
                for(int i=0;i<N;++i)
                {
                    k3[i]=h*f(i,y_tmp,t+a3*h);
                    y_tmp[i]=y[i]+b41*k1[i]+b42*k2[i]+b43*k3[i];
                }
                for(int i=0;i<N;++i)
                {
                    k4[i]=h*f(i,y_tmp,t+a4*h);
                    y_tmp[i]=y[i]+b51*k1[i]-8.0*k2[i]+b53*k3[i]+b54*k4[i];
                }
                for(int i=0;i<N;++i)
                {
                    k5[i]=h*f(i,y_tmp,t+h);
                    y4_nast[i]=y[i]+w41*k1[i]+w43*k3[i]+w44*k4[i]-0.2*k5[i]; //RK4 (5 wyrazow)
                    y_tmp[i]=y[i]+b61*k1[i]+2*k2[i]+b63*k3[i]+b64*k4[i]+b65*k5[i];
                }
                blad=0;
                for(int i=0;i<N;++i)
                {
                    k6[i]=h*f(i,y_tmp,t+0.5*h);
                    y_nast[i]=y[i]+w51*k1[i]+w53*k3[i]+w54*k4[i]+w55*k5[i]+w56*k6[i]; //RK5 (6 wyrazow)
                    blad+=Math.Abs(y_nast[i]-y4_nast[i]);
                }

                if(komunikatyNaEkranie) Console.WriteLine("RKF4(5) -- blad: {0}, krok={1}", blad, h);
                if(blad<blad_min) h*=2;
                if(blad>blad_max) h/=2;
                if(komunikatyNaEkranie) Console.WriteLine("RKF4(5) -- nowy krok={0}", h);
            }
            while(blad<blad_min || blad>blad_max);
        }

        enum Algorytm { Eulera, RK2, MidPoint, RK4, RKF45 };

        static void odeint(Algorytm algorytm,int n,funkcja f,double[] y,double t,ref double h,double[] y_nast)
        {
            switch(algorytm)
            {
                case Algorytm.Eulera:
                    odeint_Euler(n,f,y,t,h,y_nast);
                    break;
                case Algorytm.RK2:
                case Algorytm.MidPoint:
                    odeint_MidPoint(n,f,y,t,h,y_nast);
                    break;
                case Algorytm.RK4:
                    odeint_RK4(n,f,y,t,h,y_nast);
                    break;
                case Algorytm.RKF45:
                    odeint_RKF45(n,f,y,t,ref h,y_nast);
                    break;

                default:
                    throw new Exception("Nierozpoznany algorytm");
            }
        }
        #endregion

        static void Main(string[] args)
        {
            int N=2;

            double[] y=new double[N];
            double[] y_nast=new double[N];
            for(int i=0;i<N;++i)
            {
                y[i]=0;
                y_nast[i]=0;
            }
            y[0] = 1; //do oscylatora

            double tmax = 100;
            double h = 0.1;

            StreamWriter plik_wy = new StreamWriter("wyniki.dat");

            for(double t=0;t<tmax;t+=h)
            {
                //odeint_Euler(N,(funkcja)rzut,y,t,h,y_nast);
                //odeint_MidPoint(N,(funkcja)rzut,y,t,h,y_nast);
                //odeint_RK4(N,(funkcja)rzut,y,t,h,y_nast);

                //odeint_Euler(N, (funkcja)oscylacje, y, t, h, y_nast);
                //odeint_MidPoint(N, (funkcja)oscylacje, y, t, h, y_nast);
                //odeint_RK4(N, (funkcja)oscylacje, y, t, h, y_nast);
                //odeint_RKF45(N, (funkcja)oscylacje, y, t, ref h, y_nast);

                odeint(Algorytm.RKF45, N, (funkcja)oscylacje, y, t, ref h, y_nast);

                if (komunikatyNaEkranie) Console.WriteLine("t={0}\ty[0]={1:e}\ty[1]={2:e}", t, y[0], y[1]);
                plik_wy.Write("{0:e}", t);
                for (int i = 0; i < N; ++i) plik_wy.Write("\t{0:e}",y[i]);
                plik_wy.WriteLine("\t{0:e}", h);                

                //wersja brute force
                //for(int i=0;i<N;++i) y[i]=y_nast[i];

                //zamiana miejscami tablic (zonglowanie wskaznikami)
                double[] y_tmp=y;
                y=y_nast;
                y_nast=y_tmp;
            }

            plik_wy.Close();

            Console.WriteLine("\nOK.\n");
        }
    }
}
