//Wersja oryginalna (Delphi 3)
//Wersja poprawiona (JM, 5.04.2003)
//Zmiana sposobu wyswietlania (funkcja -> tor) - JM, 6.03.2010

unit PathGraph;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  fg_ftyp = double;
  TUserFunc = procedure(I: Integer; var X: fg_ftyp; var Y: fg_ftyp; var PointVisible :Boolean) of Object;
  TPathGraph = class(TGraphicControl)
  private
    FRangeMinI: Integer;
    FRangeMaxI: Integer;
    FRangeMinX: fg_ftyp;
    FRangeMaxX: fg_ftyp;
    FRangeMinY: fg_ftyp;
    FRangeMaxY: fg_ftyp;
    FPath1: TUserFunc;
    FPath2: TUserFunc;
    FPath3: TUserFunc;
    FPlotPen1: TPen;
    FPlotPen2: TPen;
    FPlotPen3: TPen;
    FBorderPen: TPen;
    FZeroAxisPen: TPen;
    FXZeroAxis: Boolean;
    FYZeroAxis: Boolean;
    FBackgroundBrush: TBrush;
    procedure SetPlotPen1(Value :TPen);
    procedure SetPlotPen2(Value :TPen);
    procedure SetPlotPen3(Value :TPen);
    procedure SetBorderPen(Value :TPen);
    procedure SetZeroAxisPen(Value :TPen);
    procedure SetBackgroundBrush(Value :TBrush);
  protected
    //
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
  published
    property RangeMinI: Integer read FRangeMinI write FRangeMinI;
    property RangeMaxI: Integer read FRangeMaxI write FRangeMaxI;
    property RangeMinX: fg_ftyp read FRangeMinX write FRangeMinX;
    property RangeMaxX: fg_ftyp read FRangeMaxX write FRangeMaxX;
    property RangeMinY: fg_ftyp read FRangeMinY write FRangeMinY;
    property RangeMaxY: fg_ftyp read FRangeMaxY write FRangeMaxY;
    property OnPath1: TUserFunc read FPath1 write FPath1;
    property OnPath2: TUserFunc read FPath2 write FPath2;
    property OnPath3: TUserFunc read FPath3 write FPath3;
    property Width default 50;
    property Height default 50;
    property PlotPen1: TPen read FPlotPen1 write SetPlotPen1;
    property PlotPen2: TPen read FPlotPen2 write SetPlotPen2;
    property PlotPen3: TPen read FPlotPen3 write SetPlotPen3;
    property BorderPen: TPen read FBorderPen write SetBorderPen;
    property ZeroAxisPen: TPen read FZeroAxisPen write SetZeroAxisPen;
    property XZeroAxis: Boolean read FXZeroAxis write FXZeroAxis;
    property YZeroAxis: Boolean read FYZeroAxis write FYZeroAxis;
    property BackgroundBrush: TBrush read FBackgroundBrush write SetBackgroundBrush;
    procedure StyleChanged(Sender: TObject);
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('JM', [TPathGraph]);
end;

constructor TPathGraph.Create(AOwner: TComponent);
begin
 inherited Create(AOwner);
 Height := 50;
 Width := 50;
 FRangeMaxX := 1;
 FRangeMaxY := 1;
 FRangeMaxI := 100;
 ShowHint := True;
 FPlotPen1:=TPen.Create;
 FPlotPen2:=TPen.Create;
 FPlotPen3:=TPen.Create;
 FPlotPen2.Style:=psDash;
 FPlotPen3.Style:=psDot;
 FBorderPen:=TPen.Create;
 FZeroAxisPen:=TPen.Create;
 FZeroAxisPen.Color:=RGB(200,200,200);
 FBackgroundBrush:=TBrush.Create;
 FPlotPen1.OnChange:=StyleChanged;
 FPlotPen2.OnChange:=StyleChanged;
 FPlotPen3.OnChange:=StyleChanged;
 FBorderPen.OnChange:=StyleChanged;
 FZeroAxisPen.OnChange:=StyleChanged;
 FBackgroundBrush.OnChange:=StyleChanged;
end;

destructor TPathGraph.Destroy;
begin
    FPlotPen1.Free;
    FPlotPen2.Free;
    FPlotPen3.Free;
    FBorderPen.Free;
    FZeroAxisPen.Free;
    FBackgroundBrush.Free;
    inherited Destroy;
end;

procedure TPathGraph.SetPlotPen1(Value: TPen);
begin
  FPlotPen1.Assign(Value);
end;

procedure TPathGraph.SetPlotPen2(Value: TPen);
begin
  FPlotPen2.Assign(Value);
end;

procedure TPathGraph.SetPlotPen3(Value: TPen);
begin
  FPlotPen3.Assign(Value);
end;

procedure TPathGraph.SetBorderPen(Value: TPen);
begin
  FBorderPen.Assign(Value);
end;

procedure TPathGraph.SetZeroAxisPen(Value: TPen);
begin
  FZeroAxisPen.Assign(Value);
end;

procedure TPathGraph.SetBackgroundBrush(Value: TBrush);
begin
  FBackgroundBrush.Assign(Value);
end;

procedure TPathGraph.StyleChanged(Sender: TObject);
begin
  Invalidate;
end;

procedure TPathGraph.Paint;
var
 I: Integer; { Parametr, np. numer elementu w tablicy }
 X, Y: Integer; { wsprzedne wykresu (w pikselach) }
 RX, RY: fg_ftyp;  { wsprzdne uytkownika }
 PointVisible :Boolean;
 XYFuncNo : Integer;
 XYFunc :TUserFunc;
begin
if FRangeMaxI=FRangeMinI then
  begin
  ShowMessage('Bd TPathGraph: RangeMaxI nie moe by rwny RangeMinI');
  Exit;
  end;
if FRangeMaxX=FRangeMinX then
  begin
  ShowMessage('Bd TPathGraph: RangeMaxX nie moe by rwny RangeMinX');
  Exit;
  end;
if FRangeMaxY=FRangeMinY then
  begin
  ShowMessage('Bd TPathGraph: RangeMaxY nie moe by rwny RangeMinY');
  Exit;
  end;

 inherited Paint;
 with Canvas do
 	begin
    //Brzeg i tlo
 	Pen:=FBorderPen;
 	Brush:=FBackgroundBrush;
 	Rectangle(0,0,Width,Height);
    //Os zerowa
    if FXZeroAxis or FYZeroAxis then
    	begin
	    Pen:=FZeroAxisPen;
        if FXZeroAxis then
        	begin
            Y:=Round((1 - ((0-FRangeMinY)/(FRangeMaxY-FRangeMinY))) * Height); //1- bo odwrotnie wsp. Canvas i wykresu
	    	MoveTo(0,Y);
        	LineTo(Width,Y);
            end;
        if FYZeroAxis then
        	begin
            X:=Round( ((0-FRangeMinX)/(FRangeMaxX-FRangeMinX)) * Width);
	    	MoveTo(X,0);
        	LineTo(X,Height);
            end;
        end;
    end;


 for XYFuncNo :=3 downto 1 do
 begin
	 case XYFuncNo of
	  3:
      	begin
      	Canvas.Pen:=FPlotPen3;
        XYFunc := FPath3; //dodatkowa jako pierwsza, zeby byla z tylu na wykresie
        end;
	  2:
      	begin
        Canvas.Pen:=FPlotPen2;
      	XYFunc := FPath2;
        end;
    1:
      	begin
        Canvas.Pen:=FPlotPen1;
      	XYFunc := FPath1;
        end;
	 end;


 //Petla po I
 for I := FRangeMinI to FRangeMaxI do
 begin
  { konwersja wsprzdnej X }
  //RX := FRangeMinX + (((FRangeMaxX - FRangeMinX)/Width)*X); //JM: RangeMaxX nie moze byc rowne RangeMinX
  PointVisible:=true; //zakladamy, ze widoczne

  { sprawdzamy, czy istnieje funkcja zdefiniowana przez uytkownika;
    jeli tak, to j wywoujemy }
  if Assigned(XYFunc) then
   XYFunc(I,RX,RY,PointVisible)
  else
   begin
   RX := 0;
   RY := 0;
   PointVisible:=false;
   end;

  { konwersja wsprzednej X, operacja rysowania }
  X := Round(( ((RX-FRangeMinX)/(FRangeMaxX-FRangeMinX))) * Width);
  { konwersja wsprzednej Y, operacja rysowania }
  Y := Round((1 - ((RY-FRangeMinY)/(FRangeMaxY-FRangeMinY))) * Height);
  if I = FRangeMinI then
   Canvas.MoveTo(X,Y)
  else
   if PointVisible then Canvas.LineTo(X,Y) else Canvas.MoveTo(X,Y);
 end;

end; //od petli po wykresach


end;


end.


