unit GIFFuncGraph;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Contnrs, GIFImage;

type
  fg_ftyp = double;
  TUserFunc = procedure(X: fg_ftyp; var Y: fg_ftyp; var PointVisible :Boolean) of Object;
  TGIFFuncGraph = class(TGraphicControl)
  private
    FRangeMinX: fg_ftyp;
    FRangeMaxX: fg_ftyp;
    FRangeMinY: fg_ftyp;
    FRangeMaxY: fg_ftyp;
    FUserFunc: TUserFunc;
    FAddUserFunc: TUserFunc;
    FPlotPen: TPen;
    FAddPlotPen: TPen;
    FBorderPen: TPen;
    FZeroAxisPen: TPen;
    FXZeroAxis: Boolean;
    FYZeroAxis: Boolean;
    FBackgroundBrush: TBrush;
    procedure SetPlotPen(Value :TPen);
    procedure SetAddPlotPen(Value :TPen);
    procedure SetBorderPen(Value :TPen);
    procedure SetZeroAxisPen(Value :TPen);
    procedure SetBackgroundBrush(Value :TBrush);
  protected
    //
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
  published
    property RangeMinX: fg_ftyp read FRangeMinX write FRangeMinX;
    property RangeMaxX: fg_ftyp read FRangeMaxX write FRangeMaxX;
    property RangeMinY: fg_ftyp read FRangeMinY write FRangeMinY;
    property RangeMaxY: fg_ftyp read FRangeMaxY write FRangeMaxY;
    property OnUserFunc: TUserFunc read FUserFunc write FUserFunc;
    property OnAddUserFunc: TUserFunc read FAddUserFunc write FAddUserFunc;
    property Width default 50;
    property Height default 50;
	  property PlotPen: TPen read FPlotPen write SetPlotPen;
    property AddPlotPen: TPen read FAddPlotPen write SetAddPlotPen;
    property BorderPen: TPen read FBorderPen write SetBorderPen;
    property ZeroAxisPen: TPen read FZeroAxisPen write SetZeroAxisPen;
    property XZeroAxis: Boolean read FXZeroAxis write FXZeroAxis;
    property YZeroAxis: Boolean read FYZeroAxis write FYZeroAxis;
    property BackgroundBrush: TBrush read FBackgroundBrush write SetBackgroundBrush;
    procedure StyleChanged(Sender: TObject);

////// GIF
  private
    FGIF: TGIFImage;
    FGIFSpeed: Integer;
    //FrameNum: integer;
    procedure SetGIFspeed(Value: integer);
  public
    procedure GIFMakeShot;
    procedure GIFSave(const FileName: string);
  published
    property GIFspeed: integer read FGIFspeed write SetGIFspeed;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('JM', [TGIFFuncGraph]);
end;

constructor TGIFFuncGraph.Create(AOwner: TComponent);
begin
 inherited Create(AOwner);
 Height := 50;
 Width := 50;
 FRangeMaxX := 1;
 FRangeMaxY := 1;
 ShowHint := True;
 FPlotPen:=TPen.Create;
 FAddPlotPen:=TPen.Create;
 FAddPlotPen.Style:=psDash;
 FBorderPen:=TPen.Create;
 FZeroAxisPen:=TPen.Create;
 FZeroAxisPen.Color:=RGB(200,200,200);
 FBackgroundBrush:=TBrush.Create;
 FPlotPen.OnChange:=StyleChanged;
 FAddPlotPen.OnChange:=StyleChanged;
 FBorderPen.OnChange:=StyleChanged;
 FZeroAxisPen.OnChange:=StyleChanged;
 FBackgroundBrush.OnChange:=StyleChanged;
 ////////GIF
 FGIF := TGIFImage.Create;
 FGIFspeed := 500;
 Include(GIFImageDefaultDrawOptions,goDirectDraw);
end;

destructor TGIFFuncGraph.Destroy;
var i :Integer;
begin
	FPlotPen.Free;
	FAddPlotPen.Free;
  FBorderPen.Free;
  FZeroAxisPen.Free;
  FBackgroundBrush.Free;
  FGIF.Free;
  inherited Destroy;
end;

procedure TGIFFuncGraph.SetPlotPen(Value: TPen);
begin
  FPlotPen.Assign(Value);
end;

procedure TGIFFuncGraph.SetAddPlotPen(Value: TPen);
begin
  FAddPlotPen.Assign(Value);
end;

procedure TGIFFuncGraph.SetBorderPen(Value: TPen);
begin
  FBorderPen.Assign(Value);
end;

procedure TGIFFuncGraph.SetZeroAxisPen(Value: TPen);
begin
  FZeroAxisPen.Assign(Value);
end;

procedure TGIFFuncGraph.SetBackgroundBrush(Value: TBrush);
begin
  FBackgroundBrush.Assign(Value);
end;

procedure TGIFFuncGraph.StyleChanged(Sender: TObject);
begin
  Invalidate;
end;

procedure TGIFFuncGraph.Paint;
var
 X, Y: Integer; { wsprzedne wykresu (w pikselach) }
 RX, RY: fg_ftyp;  { wsprzdne uytkownika }
 PointVisible :Boolean;
 XYFuncNo : Integer;
 XYFunc :TUserFunc;

begin
  if FRangeMaxX=FRangeMinX then
  begin
    ShowMessage('Bd TGIFFuncGraph: RangeMaxX nie moe by rwny RangeMinX');
    Exit;
  end;
  if FRangeMaxY=FRangeMinY then
  begin
    ShowMessage('Bd TGIFFuncGraph: RangeMaxY nie moe by rwny RangeMinY');
    Exit;
  end;

  inherited Paint;
  with Canvas do
  begin
      //Brzeg i tlo
   	Pen:=FBorderPen;
 	  Brush:=FBackgroundBrush;
   	Rectangle(0,0,Width,Height);
      //Os zerowa
      if FXZeroAxis or FYZeroAxis then
    	begin
	      Pen:=FZeroAxisPen;
        if FXZeroAxis then
      	begin
          Y:=Round((1 - ((0-FRangeMinY)/(FRangeMaxY-FRangeMinY))) * Height); //1- bo odwrotnie wsp. Canvas i wykresu
	      	MoveTo(0,Y);
        	LineTo(Width,Y);
        end;
        if FYZeroAxis then
        begin
          X:=Round( ((0-FRangeMinX)/(FRangeMaxX-FRangeMinX)) * Width);
	    	  MoveTo(X,0);
        	LineTo(X,Height);
        end;
      end;
  end;


  for XYFuncNo :=1 to 2 do
  begin
	  case XYFuncNo of
	    1:
      	begin
        	Canvas.Pen:=FAddPlotPen;
          XYFunc := FAddUserFunc; //dodatkowa jako pierwsza, zeby byla z tylu na wykresie
        end;
	    2:
      	begin
          Canvas.Pen:=FPlotPen;
      	  XYFunc := FUserFunc;
        end;
  end;


    //Petla po X
  for X := 1 to Width do
  begin
    { konwersja wsprzdnej X }
    RX := FRangeMinX + (((FRangeMaxX - FRangeMinX)/Width)*X); //JM: RangeMaxX nie moze byc rowne RangeMinX
    PointVisible:=true; //zakladamy, ze widoczne

    { sprawdzamy, czy istnieje funkcja zdefiniowana przez uytkownika;
      jeli tak, to j wywoujemy }
    if Assigned(XYFunc) then
      XYFunc(RX,RY,PointVisible)
    else
    begin
      RY := 0;
      PointVisible:=false;
    end;

    { konwersja wsprzednej Y, operacja rysowania }
    Y := Round((1 - ((RY-FRangeMinY)/(FRangeMaxY-FRangeMinY))) * Height); //JM: RangeMaxY nie moze byc rowne RangeMinY
    if X = 1 then
      Canvas.MoveTo(X,Y)
    else
      if PointVisible then Canvas.LineTo(X,Y) else Canvas.MoveTo(X,Y);
    end;

  end; //od petli po wykresach
end;

////// GIF

procedure TGIFFuncGraph.GIFMakeShot;
var
 Shot: TBitMap;
 Fragment :TRect;

  function TransparentIndex(GIF: TGIFSubImage): byte;
  begin
    // Use the lower left pixel as the transparent color
    Result := GIF.Pixels[0, GIF.Height-1];
  end;

  function AddBitmap(GIF: TGIFImage; Source: TGraphic; Transparent: boolean): integer;
  var
    Ext			: TGIFGraphicControlExtension;
    LoopExt		: TGIFAppExtNSLoop;
  begin
    // Add the source image to the animation
    Result := GIF.Add(Source);
    // Netscape Loop extension must be the first extension in the first frame!
    if (Result = 0) then
    begin
      LoopExt := TGIFAppExtNSLoop.Create(GIF.Images[Result]);
      LoopExt.Loops := 0; // Number of loops (0 = forever)
      GIF.Images[Result].Extensions.Add(LoopExt);
    end;
    // Add Graphic Control Extension
    Ext := TGIFGraphicControlExtension.Create(GIF.Images[Result]);
    Ext.Delay := round(FGIFspeed / 10); // Animation delay (30 = 300 mS)
    if (Transparent) then
    begin
      Ext.Transparent := True;
      Ext.TransparentColorIndex := TransparentIndex(GIF.Images[Result]);
    end;
    GIF.Images[Result].Extensions.Add(Ext);
  end;

begin
  Refresh;
  Shot := TBitMap.Create;
  Shot.Height := Self.ClientHeight;
  Shot.Width := Self.ClientWidth;

  //Shot.Handle := CreateCompatibleBitmap(GetWindowDC(Parent.Handle), Width, Height);
  //BitBlt(Shot.Canvas.Handle, 0, 0, Width, Height, GetWindowDC(Parent.Handle), Left+3, Top+30, SRCCOPY);

  //kopiowanie obrazu
  //Shot.Canvas.CopyRect(Self.BoundsRect,Self.Canvas,Shot.Canvas.ClipRect);
  Shot.Canvas.CopyRect(Shot.Canvas.ClipRect,Self.Canvas,Shot.Canvas.ClipRect);

  //dodawanie klatki do gifa
  AddBitmap(FGIF, // Destination GIF
    Shot, // Source bitmap
    False); // First frame is not transparent
end;

procedure TGIFFuncGraph.SetGIFspeed(Value: integer);
begin
  FGIFspeed := Value;
end;

procedure TGIFFuncGraph.GIFSave(const FileName: string);
begin
  FGIF.SaveToFile(FileName);
end;

end.
