#include <GL\glut.h>
#include <stdlib.h>
#include <stdio.h>
#include "SimulationSPH.h"
#include "Timer.h"

int windowX = 600;
int windowY = 600;
int mousePositionX;
int mousePositionY;
int licznik = 0;
Timer *tajmer;
char *tyt;
SimulationSPH *symulacja_sph;


void init()
{
	glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
	gluOrtho2D(0.0, symulacja_sph->get_wind_size().x, 0.0, symulacja_sph->get_wind_size().y);
	glViewport(0, 0, windowX, windowY);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_BLEND);
	glEnable(GL_POINT_SMOOTH);
	glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
	
	glClearColor(1.0f, 1.0f, 1.0f, 1.0);
}

void rysuj_particles()
{
	Kulka *p = symulacja_sph->get_particles();
	glColor3f(0.5f, 0.5f, 0.8f);
	glPointSize(10.0f);

	glBegin(GL_POINTS);
		for(uint i=0; i<symulacja_sph->get_num_particles(); i++)
		{
			glVertex2f(p[i].pozycja.x, p[i].pozycja.y);
		}
	
	glEnd();
}

void display()
{
	symulacja_sph->animacja();

	glClear(GL_COLOR_BUFFER_BIT);
	rysuj_particles();
	glutSwapBuffers();

	tajmer->odsw();
	memset(tyt, 0, 50);
	glutSetWindowTitle(tyt);
}

void idleFunc()
{
	glutPostRedisplay();
}

void reshapeFunc(int width, int height)
{
	windowX = width;
	windowY = height;
	glViewport(0, 0, windowX, windowY);
	glutReshapeWindow(windowX, windowY);
}
/*
void Mouse(int klawisz, int stan,int x, int y) {
	
	
	symulacja_sph->mysz_x = (float)x;
	symulacja_sph->mysz_y = (float)y;
	if (klawisz == GLUT_LEFT_BUTTON) {
		//sph[1] = new SPHSystem();
		symulacja_sph->init_ciecz();
	}
		//glutIdleFunc(Obroty);
}*/


void Mouse(int klawisz, int stan, int x, int y) {


	//symulacja_sph->mysz_x = (float)x;
	//symulacja_sph->mysz_y = (float)y;
	if (klawisz == GLUT_LEFT_BUTTON) {
		//sph[1] = new SPHSystem();

		GLint viewport[4]; 
		GLdouble modelview[16]; 
		GLdouble projection[16]; 
		GLfloat winX, winY, winZ; 
		GLdouble worldX, worldY, worldZ; //prawidowa pozycja
		worldX = 600;
		worldY = 600;
		worldZ = 0;
		glGetDoublev(GL_MODELVIEW_MATRIX, modelview); 
		glGetDoublev(GL_PROJECTION_MATRIX, projection); 
		glGetIntegerv(GL_VIEWPORT, viewport); 

		winX = (float)x;
		winY = (float)viewport[3] - (float)y;
		winZ = 0;
		glReadPixels(x, int(winY), 1, 1, GL_DEPTH_COMPONENT, GL_FLOAT, &winZ);
		
	
		gluUnProject(winX, winY, winZ, modelview, projection, viewport,  &worldX, &worldY,  &worldZ);

		symulacja_sph->mysz_x = (float)worldX;
		symulacja_sph->mysz_y = (float)worldY;
		if(stan==GLUT_DOWN)
		symulacja_sph->init_ciecz();
		
	}
	//glutIdleFunc(Obroty);
}

int main(int argc, char **argv)
{
	symulacja_sph = new SimulationSPH();
	
	//symulacja_sph->init_ciecz();
	
	tajmer=new Timer();
	tyt=(char *)malloc(sizeof(char)*50);

	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE);
	glutInitWindowSize(windowX, windowY);
	glutCreateWindow("Symulacja SPH 2D");
	glutDisplayFunc(display);
	glutReshapeFunc(reshapeFunc);
	glutIdleFunc(idleFunc);
	glutMouseFunc(Mouse);
	init();
	glutMainLoop();
	
	free(symulacja_sph);
	return 0;
}
