#pragma once
#include "stdafx.h"

using namespace std;

template <class Type>
class Model
{
public:
	const Type g = 9.8;		//gravitational constant
	const Type dt = 0.01;		//timestep
	const Type n = 0.01;		//constant eta
	const Type beta = 1.0;		//constant beta
	const Type alpha = 0.5;	//constant alpha
	const Type h = 100;		//smoothnes lenght parameter

	int qVessel;
	Vector3<Type> * vessel;

	Environment<Type> * environment;
	int quantity;

	//ofstream energyFile;
	ofstream positionFile;
	ofstream vesselFile;
	ofstream configFile;
	ofstream vFile;
	ofstream aFile;

	int step = 0;
	int tempStep = step;
	int frames;

	Type K = 0;
	Vector3<Type> gravity;

	Model(int envirionmentsQuantity,
		long int * particlesQuantity,
		Type * mass,
		Type * density,
		Type * pressure,
		Type * k,
		string * name,
		int frames,
		int _qVessel
		)
	{
		qVessel = _qVessel;
		createVessel();
		gravity.y = -g / 20;
		quantity = envirionmentsQuantity;
		environment = new Environment<Type>[envirionmentsQuantity];
		for (int i = 0; i < envirionmentsQuantity; i++)
		{
			Environment<Type> temp(particlesQuantity[i], mass[i], density[i], pressure[i], k[i], name[i]);
			environment[i] = temp;
		}

		//energyFile.open("energie.dat");
		positionFile.open("pozycje.dat");
		vFile.open("predkosci.dat");
		aFile.open("przyspieszenia.dat");
		//energyFile.clear();
		positionFile.clear();

		for (step = 0; step < frames; step++)
		{
			system("cls");
			float prcnt = ((float)step / frames) * 100;
			cout << endl << endl << endl << endl << "\t\t\t\t" << prcnt << "%" << endl;
			//cout << step << "%" << endl;
			time_t timeBefore = time(0);
			//cout << "Calculating density for step " << step;
			calculateDensity();
			//cout << " | " << time(0) - timeBefore << "s" << endl;

			timeBefore = time(0);
			//cout << "Calculating acceleration for step " << step;
			calculateAcceleration();
			//cout << " | " << time(0) - timeBefore << "s" << endl;

			timeBefore = time(0);
			//cout << "Calculating velocity and position for step " << step;
			calculateNextVelocityAndPosition();
			//cout << " | " << time(0) - timeBefore << "s" << endl;

			//energyFile << step << "\t";

			//calculateEnergy();
		}
		//energyFile.close();
		positionFile.close();
		vFile.close();
		aFile.close();
	}

	friend ostream &operator << (ostream &os, const Model &mod)
	{
		for (int i = 0; i < mod.quantity; i++)
		{
			os << mod.environment[i] << endl;
		}

		return os;
	}

	void calculateEnergy()
	{
		double energy = 0;
		for (int i = 0; i < quantity; i++)
		{
			for (long int j = 0; j < environment[i].quantity; j++)
			{
				energy += environment[i].particle[j].v.lenght();
			}
			energy *= energy;
			energy *= environment[i].mass / 2;

			energy *= 100000000000000;
		}
		energyFile.precision(15);

		energyFile << energy << endl;
	}

	Type W(int envI, int envJ, long int i, long int j)
	{
		Type norm = 1 / (3.14 * powf(h, 3));

		Vector3<Type> r = environment[envI].particle[i].r - environment[envJ].particle[j].r;
		Type u = r.lenght() / h;

		if (u >= 0 && u <= 1)
			return norm*(1 - 3 / 2 * u*u + 3 / 4 * powf(u, 3));
		else if (u > 1 && u <= 2)
			return norm*(1 / 4 * powf((2 - u), 3));
		else
			return 0;
	}

	Vector3<Type> gradW(int envI, int envJ, long int i, long int j)
	{
		Type norm = 1 / (3.14 * powf(h, 4));

		Vector3<Type> r = environment[envI].particle[i].r - environment[envJ].particle[j].r;
		Type u = r.lenght() / h;

		r /= r.lenght();

		Type endW = 0;

		if (u >= 0 && u <= 1)
			endW = -3 * u + 9 / 4 * u*u;
		else if (u > 1 && u <= 2)
			endW = -3 / 4 * powf((2 - u), 2);

		r *= norm * endW;

		return r;
	}

	void updateDensity(int env, long int i)
	{
		environment[env].particle[i].density = 0;
		for (int e = 0; e < quantity; e++)
		{
			for (int j = 0; j < environment[e].quantity; j++)
			{
				environment[env].particle[i].density += environment[env].mass * W(env, e, i, j);
			}
		}
	}

	void calculateDensity()
	{
		for (int e = 0; e < quantity; e++)
		{
			for (int j = 0; j < environment[e].quantity; j++)
			{
				updateDensity(e, j);
			}
		}
	}

	void createVessel()
	{
		positionFile.open("naczynie.dat");
		positionFile.clear();

		vessel = new Vector3<Type>[qVessel];

		//
		/*vessel[0].x = 0;
		vessel[0].y = 0;
		vessel[0].z = 0;
		positionFile << vessel[0].x << "\t" << vessel[0].y << "\t" << vessel[0].z << "\n";*/


		//qvsl: (row+1)^2 + 2*cols*row + 2*cols*(row-2)        168
		int row = floor(sqrt(qVessel / 2)) - 1;
		int hrow = row / 2;
		int d = 82;

		int q = 0;
		for (int i = -hrow; i < hrow + 1; i++)
		{
			for (int j = -hrow; j < hrow + 1; j++)
			{
				/*if (i == -hrow || i == hrow || j == hrow || j == -hrow)
				{
					vessel[q].x = (float)i / 100;
					vessel[q].y = 0.01;
					vessel[q].z = (float)j / 100;

					positionFile << vessel[q].x << "\t" << vessel[q].y << "\t" << vessel[q].z << "\n";
					q++;

					vessel[q].x = (float)i / 100;
					vessel[q].y = 0.02;
					vessel[q].z = (float)j / 100;

					positionFile << vessel[q].x << "\t" << vessel[q].y << "\t" << vessel[q].z << "\n";
					q++;

					vessel[q].x = (float)i / 100;
					vessel[q].y = 0.03;
					vessel[q].z = (float)j / 100;

					positionFile << vessel[q].x << "\t" << vessel[q].y << "\t" << vessel[q].z << "\n";
					q++;
				}*/

				vessel[q].x = (float)i / d;
				vessel[q].y = 0;
				vessel[q].z = (float)j / d;

				positionFile << vessel[q].x << "\t" << vessel[q].y << "\t" << vessel[q].z << "\n";	
				q++;

				vessel[q].x = (float)i / d;
				vessel[q].y = 0.01;
				vessel[q].z = (float)j / d;

				positionFile << vessel[q].x << "\t" << vessel[q].y << "\t" << vessel[q].z << "\n";
				q++;
			}
		}

		/* ok 700 cz "WOK"
		float r = 0.5;
		float z = 0;
		int i = 0;
		int layers = 10;

		for (int j = 0; j < layers; j++)
		{
		float alph = 0;
		while (alph < 2 * 3.14)
		{
		vessel[i].x = r * cosf(alph) / 5;
		vessel[i].z = r * sinf(alph) / 5;
		vessel[i].y = z / 7;
		positionFile << vessel[i].x << "\t" << vessel[i].y << "\t" << vessel[i].z << "\n";
		alph += 0.1;
		i++;
		}
		z -= 0.05;
		r -= 0.05;
		}*/


		positionFile.close();
	}

	Type maxVelocity()
	{
		Type max = 0;

		for (int env = 0; env < quantity; env++)
		{
			for (int i = 0; i < environment[env].quantity; i++)
			{
				Type v = environment[env].particle[i].v.lenght();
				if (v > max) max = v;
			}
		}

		return max*max;
	}

	Vector3<Type> F(int env, long int i, int j)
	{
		Type r0 = 0.015; //cutoff distance
		Vector3<Type> r = environment[env].particle[i].r - vessel[j];
		Type dr = r.lenght();
		if (dr == 0)
			cout << "\b ERROR" << endl;

		Vector3<Type> force = Vector3<Type>();

		if (dr / r0 <= 1)
		{
			force = r;
			force *= (K / powf(dr, 2));
			force *= (powf(r0 / dr, 12) - powf(r0 / dr, 4));
		}

		/*Type r0 = 0.5;
		Vector3<Type> r = vessel[j] - environment[env].particle[i].r;
		Type dr = r.lenght();

		Vector3<Type> force = Vector3<Type>();
		float D = 1000;
		if (r.lenght() < r0)
		force.x = D * (powf(r.x / r0, 4) - powf(r.x / r0, 2));
		if (r.lenght() < r0)
		force.y = D * (powf(r.y / r0, 4) - powf(r.y / r0, 2));
		if (r.lenght() < r0)
		force.z = D * (powf(r.z / r0, 4) - powf(r.z / r0, 2));*/

		return force;
	}

	Vector3<Type> calculateBoundaryConditions(int env, long int i)
	{
		Vector3<Type> forces;

		for (int j = 0; j < qVessel; j++)
		{
			forces += F(env, i, j);
		}

		if (forces.y != 0) ("%E \n", forces.y);
		return forces;
	}

	void calculateAcceleration()
	{
		K = maxVelocity();
		for (int i = 0; i < quantity; i++)
		{
			Type c = sqrtf(environment[i].k * (environment[i].pressure / environment[i].density));

			for (long int j = 0; j < environment[i].quantity; j++)
			{
				environment[i].particle[j].a.zeroIt();
				for (long int l = 0; l < environment[i].quantity; l++)
				{
					if (l != j)
					{
						Type my = 0;
						Vector3<Type> v = environment[i].particle[j].v - environment[i].particle[l].v;
						Vector3<Type> r = environment[i].particle[j].r - environment[i].particle[l].r;
						if (v*r < 0)
							my = (v*r) / ((r.lenght()*r.lenght() / h) + h*n*n);
						Type density = (environment[i].particle[j].density + environment[i].particle[l].density) / 2;
						Type product = (-alpha*c*my + beta*my*my) / density;

						Vector3<Type> tempA;
						tempA = gradW(i, i, j, l);
						tempA *= environment[i].mass * (1 / environment[i].particle[j].density + 1 / environment[i].particle[l].density + product);


						environment[i].particle[j].a += tempA;
					}

				}

				environment[i].particle[j].a *= -c*c*(1 / environment[i].k);
				environment[i].particle[j].a += gravity; //adding gravitation force

				Vector3<Type> boundaryForces = calculateBoundaryConditions(i, j);
				boundaryForces *= 0.2; //mass of vessel
				environment[i].particle[j].a += boundaryForces; //adding boundary conditions
			}
		}
	}

	void calculateNextVelocityAndPosition()
	{
		for (int i = 0; i < quantity; i++)
		{
			for (long int j = 0; j < environment[i].quantity; j++)
			{
				//EULER
				environment[i].particle[j].v += environment[i].particle[j].a *dt;
				environment[i].particle[j].r += environment[i].particle[j].v *dt;

				positionFile.precision(5);
				positionFile << environment[i].particle[j].r << endl;

				vFile << environment[i].particle[j].v << endl;
				aFile << environment[i].particle[j].a << endl;
			}
		}
	}

	~Model()
	{
		delete[] environment;
		delete[] vessel;
	}
};