.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutSpaceballRotateFunc 3GLUT "3.5" "GLUT" "GLUT"
.SH NAME
glutSpaceballRotateFunc - sets the Spaceball rotation callback for the current
window. 
.SH SYNTAX
.nf
.LP
void glutSpaceballRotateFunc(void (*func)(int x, int y, int z));
.fi
.SH ARGUMENTS
.IP \fIfunc\fP 1i
The new spaceball rotate callback function. 
.SH DESCRIPTION
glutSpaceballRotateFunc sets the Spaceball rotate callback for the
current window. The Spaceball rotate callback for a window is called
when the window has Spaceball input focus (normally, when the mouse
is in the window) and the user generates Spaceball rotations. The x, y,
and z callback parameters indicate the rotation along the X, Y, and Z
axes. The callback parameters are normalized to be within the range of
-1800 to 1800 inclusive. 

Registering a Spaceball rotate callback when a Spaceball device is not
available is ineffectual and not an error. In this case, no Spaceball rotate
callbacks will be generated. 

Passing NULL to glutSpaceballRotateFunc disables the generation
of Spaceball rotate callbacks. When a new window is created, no
Spaceball rotate callback is initially registered. 
.SH SEE ALSO
glutSpaceballMotionFunc, glutSpaceballButtonFunc, glutMotionFunc, glutTabletMotionFunc, glutDeviceGet
.SH AUTHOR
Mark J. Kilgard (mjk@sgi.com)
