#include "SPHSystem.h"
#include <glut.h>
#include <SOIL.h>
#define EPSILON 0.00001



// index array of vertex array for glDrawElements() & glDrawRangeElement()
GLubyte indices[] = { 0, 1, 2, 2, 3, 0,      // front
4, 5, 6, 6, 7, 4,      // right
8, 9, 10, 10, 11, 8,      // top
12, 13, 14, 14, 15, 12,      // left
16, 17, 18, 18, 19, 16,      // bottom
20, 21, 22, 22, 23, 20 };    // back






SPHSystem::SPHSystem(){}
SPHSystem::~SPHSystem(void){}

void SPHSystem::init()
{
	mMin = glm::vec3(0);
	mMax = glm::vec3(ROZMIAR, ROZMIAR, ROZMIAR);
	initBuffers();
	initializePositions();
	initGrid();
	initKernels();
}

void SPHSystem::initBuffers()
{
	glGenBuffers(1, &m_vbo);
}

void SPHSystem::initKernels()
{
	mPolyKernel = 315 / (64 * M_PI*pow(ROZMIAR_KOMORKI, 9.0));
	mSpikyKernel = -45 / (M_PI*pow(ROZMIAR_KOMORKI, 6));
	mViscousKernel = 45 / (M_PI*pow(ROZMIAR_KOMORKI, 6));
}

void SPHSystem::initGrid()
{
	sg = (HashTable*)malloc(sizeof(HashTable));
	sg->size = 2 * ROZMIAR_SIATKI * ROZMIAR_SIATKI;
	sg->first = (Particle**)malloc(sg->size*sizeof(Particle));
	for(int i = 0; i < sg->size; i++)
	{
		sg->first[i] = NULL;
	}
}

void SPHSystem::initializePositions()
{
	TOTAL_PARTICLES = 0;
	float spacing = ROZMIAR_KOMORKI*0.6;


	for (float k = spacing; k < mMax.z; k += spacing)
	{
	for(float i = spacing; i < mMax.y ; i+=spacing)
	{
		for (float j = spacing + 0.3; j < mMax.x - 0.3; j += spacing)
		{

			if (TOTAL_PARTICLES < LICZBA_KOMREK){
				glm::vec3 p = glm::vec3(i, j, 0);
				glm::vec3 v = glm::vec3(0.0, 0.0, 0);
				glm::vec3 a = glm::vec3(0, 0, 0);
				glm::vec3 vprev = v - 0.5f * float(DELTA_T) * a;
				glm::vec3 force = glm::vec3(0);
				mP.push_back(p);
				mV.push_back(v);
				mA.push_back(a);
				mVprev.push_back(vprev);
				mDensity.push_back(GESTOSC);
				mPressure.push_back(0);
				mForce.push_back(force);
				TOTAL_PARTICLES++;
			}
		}
		}
	}

	
}



void SPHSystem::drawBoundary(Camera &cam)
{
	float dx = mMax.x - mMin.x;
	float dy = mMax.y - mMin.y;
	float dz = mMax.z - mMin.z;

	enableFixedFunction(cam);
	glLineWidth(4);
	glBegin(GL_LINE_STRIP);

	//2d
		glVertex3f(mMin.x, mMin.y, mMin.z);
		glVertex3f(mMin.x+dx, mMin.y, mMin.z);
		glVertex3f(mMax.x, mMax.y, mMin.z);
		glVertex3f(mMax.x-dx, mMax.y, mMin.z);
		glVertex3f(mMin.x, mMin.y, mMin.z);

		//3d
		/*glVertex3f(mMin.x, mMin.y, mMin.z-dz);
		glVertex3f(mMin.x + dx, mMin.y, mMin.z-dz);
		glVertex3f(mMax.x, mMax.y, mMin.z-dz);
		glVertex3f(mMax.x - dx, mMax.y, mMin.z-dz);
		glVertex3f(mMin.x, mMin.y, mMin.z-dz);
		glVertex3f(mMax.x - dx, mMax.y, mMin.z - dz);
		glVertex3f(mMax.x - dx, mMax.y, mMin.z );
		glVertex3f(mMax.x, mMax.y, mMin.z);
		glVertex3f(mMax.x, mMax.y, mMin.z-dz);
		glVertex3f(mMin.x + dx, mMin.y, mMin.z-dz);
		glVertex3f(mMin.x + dx, mMin.y, mMin.z );
		*/
	glEnd();
	disableFixedFunction();
}

void DrawCircle()
{
	glBegin(GL_POLYGON);
	//Change the 6 to 12 to increase the steps (number of drawn points) for a smoother circle
	//Note that anything above 24 will have little affect on the circles appearance
	//Play with the numbers till you find the result you are looking for
	//Value 1.5 - Draws Triangle
	//Value 2 - Draws Square
	//Value 3 - Draws Hexagon
	//Value 4 - Draws Octagon
	//Value 5 - Draws Decagon
	//Notice the correlation between the value and the number of sides
	//The number of sides is always twice the value given this range
	for (double i = 0; i < 2 * 3.14; i += 3.14 / 24) //<-- Change this Value
		glVertex3f(cos(i) * 0.02, sin(i) * 0.02, 0.0);
	glEnd();

}
void onInitialization()
{
	glEnable(GL_POINT_SPRITE); // GL_POINT_SPRITE_ARB if you're
	// using the functionality as an extension.

	//GLuint texture_id = SOIL_load_OGL_texture
		(
		"14.-water-texture.jpg",
		SOIL_LOAD_AUTO,
		SOIL_CREATE_NEW_ID,
		SOIL_FLAG_NTSC_SAFE_RGB | SOIL_FLAG_MULTIPLY_ALPHA
		);
	
	glPointSize(30.0);

	/* assuming you have setup a 32-bit RGBA texture with a legal name */
	glActiveTexture(GL_TEXTURE0);
	glEnable(GL_TEXTURE_2D);
	glActiveTexture(GL_TEXTURE0);
	// SOIL_load_image()

	//glTexEnv(GL_POINT_SPRITE, GL_COORD_REPLACE, GL_TRUE);
	//glTexEnv(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
	//glBindTexture(GL_TEXTURE_2D, texture_id);

}


void SPHSystem::render(int pos_loc, Camera &cam)
{
	
	if(true)
	{
		drawBoundary(cam);
	}
	//glBindBuffer(GL_ARRAY_BUFFER, m_vbo);
	//glBufferData(GL_ARRAY_BUFFER, mP.size()*sizeof(glm::vec3), &mP[0], GL_STREAM_DRAW);
	//glEnableClientState(GL_NORMAL_ARRAY);
	//glEnableClientState(GL_COLOR_ARRAY);
	//glEnableClientState(GL_VERTEX_ARRAY);
	//glNormalPointer(GL_FLOAT,0, vertices3 + 3);
	//glColorPointer(3, GL_FLOAT,0, vertices3 + 6);
	//glVertexPointer(3, GL_FLOAT, 0, vertices3);


	//glPushMatrix();
	//glTranslatef(-2, -2, 0);                // move to bottom-left
	//glBindBuffer(GL_ARRAY_BUFFER, 0);
	//glDrawElements(GL_TRIANGLES, 36, GL_UNSIGNED_BYTE, indices);

	//glPopMatrix();

	//glDisableClientState(GL_VERTEX_ARRAY);  // disable vertex arrays
	//glDisableClientState(GL_COLOR_ARRAY);
	//glDisableClientState(GL_NORMAL_ARRAY);
	
	
	glBindBuffer(GL_ARRAY_BUFFER, m_vbo);
	glBufferData(GL_ARRAY_BUFFER, mP.size()*sizeof(glm::vec3), &mP[0], GL_STREAM_DRAW);
	glEnable(GL_TEXTURE_2D);

	
	glDepthMask(GL_FALSE);
	glDisable(GL_DEPTH_TEST);

	//glEnableClientState(GL_NORMAL_ARRAY);
	//glEnableClientState(GL_COLOR_ARRAY);
	//glEnableClientState(GL_VERTEX_ARRAY);
	//glNormalPointer(GL_FLOAT,0, vertices3 + 3);
	//glColorPointer(3, GL_FLOAT,0, vertices3 + 6);
	//glVertexPointer(3, GL_FLOAT, 0, vertices3);

	//glPushMatrix();
	//glTranslatef(-2, -2, 0);  

	glVertexAttribPointer(pos_loc, 3, GL_FLOAT, GL_FALSE, 0, 0);
	//glVertexAttrib2f(pos_loc, 0, 0);
	glBindBuffer(GL_ARRAY_BUFFER, 0);
	//DrawCircle(1, 1, 0.01, 24);
	onInitialization();

	glEnable(GL_POINT_SMOOTH);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_POINT_SPRITE_ARB);
	glTexEnvi(GL_POINT_SPRITE_ARB, GL_COORD_REPLACE_ARB, GL_TRUE);
	
	glDrawArrays(GL_POINTS, 0, mP.size());
	
	glEnable(GL_DEPTH_TEST);
	glDepthMask(GL_TRUE);
	glDisable(GL_BLEND);

	//glutSolidSphere(0.15, 5, 10);
	//glDrawElements(GL_TRIANGLES, 36, GL_UNSIGNED_BYTE, indices);
	//glPopMatrix();

	//glDisableClientState(GL_VERTEX_ARRAY);  // disable vertex arrays
	//glDisableClientState(GL_COLOR_ARRAY);
	//glDisableClientState(GL_NORMAL_ARRAY);
}

int SPHSystem::computeHash(glm::vec3 p)
{
	int x = floor(p.x / ROZMIAR_KOMORKI);
	int y = floor(p.y / ROZMIAR_KOMORKI);
	int z = floor(p.z / ROZMIAR_KOMORKI);

	
	//This limits the coordinates withing the grid size along x or y
	/*
		for e.g. if x = 45
		x = x & 31
		x = 13 
		how?
		(45 - 31) - 1
		(exceeded number - limit) - 1
	*/
	x = x & int(ROZMIAR_SIATKI - 1);
	y = y & int(ROZMIAR_SIATKI - 1);
	z = z & int(ROZMIAR_SIATKI - 1);

	return (int((y*ROZMIAR_SIATKI) + x));
}

void SPHSystem::addToGrid(int hash, int index)
{
	if(sg->first[hash] != NULL)
	{
		Particle* list = sg->first[hash];
		while(list->next != NULL)
		{
			list = list->next;
		}
		Particle* newParticle = (Particle*)malloc(sizeof(Particle));
		newParticle->n = index;
		newParticle->next = NULL;
		list->next = newParticle;
	}
	else{
		sg->first[hash] = (Particle*)malloc(sizeof(Particle));
		sg->first[hash]->n = index; 
		sg->first[hash]->next = NULL;
	}
}

void SPHSystem::updateGrid(){

	//clear existing grid
	for(int i = 0 ; i <sg->size;i++)
	{
		free(sg->first[i]);
	}

	//allocate new memory
	sg->first = (Particle**)malloc(sg->size*sizeof(Particle));
	for(int i = 0; i < sg->size; i++)
	{
		sg->first[i] = NULL;
	}
	
	//loop through each particle 
	for(int i = 0 ; i < TOTAL_PARTICLES ; i++)
	{
		glm::vec3 p = mP[i];
		int hash = computeHash(p);
		addToGrid(hash, i);

	}
}

void SPHSystem::neighbours(glm::vec3 p, int neighbourList[], int &count)
{
	float rad = ROZMIAR_KOMORKI;
	glm::vec3 min = glm::vec3(p.x-rad,p.y-rad, p.z-rad);
	glm::vec3 max = glm::vec3(p.x+rad,p.y+rad, p.z+rad);
	count = 0;

	for(float x = min.x; x <= max.x; x+=rad)
	{
		for(float y = min.y; y <= max.y; y+=rad)
		{
			//for (float z = min.z; z <= max.z; z += rad)
			{
				glm::vec3 pp = glm::vec3(x, y, 0);
				int hash = computeHash(pp);
				if (true)
				{
					Particle* list = sg->first[hash];
					while (list != NULL)
					{
						neighbourList[count] = list->n;
						list = list->next;
						count++;
					}
				}
			}
		}
	}
}

void SPHSystem::clearAcceleration()
{
	for(int i=0 ; i < TOTAL_PARTICLES; i++)
	{
		mA[i] = glm::vec3(0.f);
		mForce[i] = glm::vec3(0.f);
	}

}


void SPHSystem::computeDensity()
{
	/*
	Poly Kernel:
		(315 / 64 * pi * h^9) * (h^2 - r^2) ^ 3
	*/
	double h2 = ROZMIAR_KOMORKI * ROZMIAR_KOMORKI;

	//for each particle
	//find its neighbour

	for(int i = 0; i < TOTAL_PARTICLES ; ++i)
	{
		int list[LICZBA_KOMREK];
		int count;
		neighbours(mP[i], list, count);	

		glm::vec3 pi = mP[i];
		//scale down to fluid world
		//pi *= 0.004;
		double sum = 0;
		mDensity[i]=0;
		mPressure[i]=0;
		for(int j = 0 ; j < count ; ++j)
		{
			
			glm::vec3 pj = mP[list[j]];
			//scale down to fluid world
			//pj *= SIM_SCALE;
			double r = glm::length(pj - pi);
			double r2 = r*r;
			if(h2 > r2 && EPSILON <= r2){
				double cube = (h2 - r2);
				sum += cube * cube * cube;
			}
		}
		mDensity[i] += sum * mPolyKernel * MASA_POJEDYNCZEJ_CZASTECZKI;
		//mPressure[i] += STALA_GAZOWA * (pow(mDensity[i] / GESTOSC, 7) - 1);
		mPressure[i] += STALA_GAZOWA * (mDensity[i] - GESTOSC);
	}

	
}

void SPHSystem::computePressureForce()
{
	double h = ROZMIAR_KOMORKI;
	double h2 = ROZMIAR_KOMORKI * ROZMIAR_KOMORKI;

	for(int i = 0; i < TOTAL_PARTICLES ; ++i)
	{
		int list[LICZBA_KOMREK];
		int count;
		neighbours(mP[i], list, count);

		glm::vec3 pi = mP[i];
		glm::vec3 vi = mV[i];
		float pres_i = mPressure[i];
		
		//scale down to fluid world
		//pi *= SIM_SCALE;
		glm::vec3 sumPressure = glm::vec3(0);
		glm::vec3 sumViscous= glm::vec3(0);
		for(int j = 0 ; j < count ; ++j)
		{

			glm::vec3 pj = (glm::vec3)mP[list[j]];
			glm::vec3 vj = (glm::vec3)mV[list[j]];
			float pres_j = mPressure[list[j]];
			float dens_j = mDensity[list[j]];
			//scale down to fluid world
		
			glm::vec3 diff = pi - pj;
			float r = glm::length(pj - pi);
			float r2 = r*r;
			if(h2 > r2 && EPSILON <= r2){
				float square = (h - r);
				sumPressure += diff/r *((pres_i+pres_j)/(2*dens_j)) * square * square;
				sumViscous += (vj - vi)/dens_j * (square);
			}
		}
		mForce[i] += (sumPressure * (float(MASA_POJEDYNCZEJ_CZASTECZKI) * mSpikyKernel * -1.f));
		mForce[i] += (sumViscous * (float(LEPKOSC * MASA_POJEDYNCZEJ_CZASTECZKI) * mViscousKernel));
	}
}


void SPHSystem::neighbourSearch()
{
	for(int i = 0; i < TOTAL_PARTICLES ; ++i)
	{
		int list[LICZBA_KOMREK];
		int count;
		neighbours(mP[i], list, count);
		/*std::cout<<"Neighbour of "<<i<<":";
		for(int j = 0 ; j < count ; ++j)
		{
			std::cout<<j<<" ";
		}
		std::cout<<std::endl;*/
	}
}

void SPHSystem::update(){
	updateGrid();
	/* This function is only meant to check performance
	Do not use it for actual simulation*/
	//neighbourSearch(); 
	
	clearAcceleration();
	computeDensity();
	computePressureForce();
	checkBoundary();
	step();
}

void SPHSystem::checkBoundary()
{
	float wallStiff = 500.0; 
	float wallDamp = 0.5; 
	float radius = ROZMIAR_KOMORKI*0.6;
	float diff;
	double adj;
	glm::vec3 norm;
	float padding = ROZMIAR_KOMORKI*0.5;

	for(int i = 0 ; i < TOTAL_PARTICLES ; i++)
	{
		//X Walls left
		norm = glm::vec3(1, 0, 0);
		diff = 2*radius - (mP[i].x - (mMin.x+padding));
		if(diff > EPSILON)
		{
			adj = wallStiff * diff - wallDamp* glm::dot(norm, mVprev[i]);
			mA[i] += float(adj) * norm;
		}

		//X Walls right
		norm = glm::vec3(-1, 0, 0);
		diff = 2*radius - ((mMax.x-padding) - mP[i].x);
		if(diff > EPSILON)
		{
			adj = wallStiff * diff - wallDamp* glm::dot(norm, mVprev[i]);
			mA[i] += float(adj) * norm;
		}

		//Y Walls Down
		norm = glm::vec3(0, 1, 0);
		diff = 2*radius - (mP[i].y - (mMin.y+padding));
		if(diff > EPSILON)
		{
			adj = wallStiff * diff - wallDamp* glm::dot(norm, mVprev[i]);
			mA[i] += float(adj) * norm;
		}

		//Y Walls Up
		norm = glm::vec3(0, -1, 0);
		diff = 2*radius - ((mMax.y-padding) - mP[i].y);
		if(diff > EPSILON)
		{
			adj = wallStiff * diff - wallDamp* glm::dot(norm, mVprev[i]);
			mA[i] += float(adj) * norm;
		}
		////Z Walls Back
		//norm = glm::vec3(0, 0, -1);
		//diff = 2 * radius - (mP[i].z - (mMin.z + padding));
		//if (diff > EPSILON)
		//{
		//	adj = wallStiff * diff - wallDamp* glm::dot(norm, mVprev[i]);
		//	mA[i] += float(adj) * norm;
		//}

		////Z Walls Front
		//norm = glm::vec3(0, 0, 1);
		//diff = 2 * radius - ((mMax.z - padding) - mP[i].z);
		//if (diff > EPSILON)
		//{
		//	adj = wallStiff * diff - wallDamp* glm::dot(norm, mVprev[i]);
		//	mA[i] += float(adj) * norm;
		//}
	}
}

void SPHSystem::step()
{
	float dt = DELTA_T;
	for(int i = 0 ; i < TOTAL_PARTICLES ; i++)
	{
		mA[i] += mForce[i]/(mDensity[i]);
		mA[i] += glm::vec3(0, GRAWITACJA, 0);
		mV[i] += mA[i] * dt;
		//glm::vec3 vhalf =	mVprev[i] + dt * mA[i];
		mP[i] += mV[i] * dt;
		//mV[i] += ( vhalf + mVprev[i] ) * 0.5f;
		//mVprev[i] = vhalf;
	}
}