﻿using Android.Content;
using Android.Database;
using Android.Database.Sqlite;
using System.Collections.Generic;

namespace BazaDanychSQLite
{
    public class BazaDanychOsob : SQLiteOpenHelper
    {
        public BazaDanychOsob(Context context)
            : base(context, "osoby.db", null, 1)
        {

        }

        public override void OnCreate(SQLiteDatabase db)
        {
            string createCommand = "create table " + Osoba.NazwaTabeli + "(";
            for (int numerKolumny = 0; numerKolumny < Osoba.NazwyKolumnTabeli.Length; ++numerKolumny)
            {
                string nazwaKolumny = Osoba.NazwyKolumnTabeli[numerKolumny];
                string własnościKolumny = Osoba.WłasnościKolumnTabeli[numerKolumny];
                createCommand += nazwaKolumny + " " + własnościKolumny + ",";
            }
            createCommand = createCommand.Substring(0, createCommand.Length - 1);
            createCommand += ")";
            db.ExecSQL(createCommand);

        }

        public override void OnUpgrade(SQLiteDatabase db, int oldVersion, int newVersion)
        {
            //zmiana wersji
        }

        private ContentValues wartościZOsoby(Osoba osoba)
        {
            ContentValues wartości = new ContentValues();
            wartości.Put(Osoba.NazwyKolumnTabeli[0], osoba.Id);
            wartości.Put(Osoba.NazwyKolumnTabeli[1], osoba.Imię);
            wartości.Put(Osoba.NazwyKolumnTabeli[2], osoba.Nazwisko);
            wartości.Put(Osoba.NazwyKolumnTabeli[3], osoba.Wiek);
            wartości.Put(Osoba.NazwyKolumnTabeli[4], osoba.NumerTelefonu);
            return wartości;
        }

        public void DodajRekord(Osoba osoba)
        {
            SQLiteDatabase db = this.WritableDatabase;
            ContentValues wartości = wartościZOsoby(osoba);
            db.InsertOrThrow(Osoba.NazwaTabeli, null, wartości);
        }

        private Osoba osobaZKaretki(ICursor karetka)
        {
            Osoba osoba = new Osoba(
                    karetka.GetInt(0), //Id
                    karetka.GetString(1), //Imię
                    karetka.GetString(2), //Nazwisko
                    karetka.GetInt(3), //Wiek
                    karetka.GetInt(4)); //NumerTelefonu
            return osoba;
        }

        public Osoba[] PobierzWszystkieRekordy(string orderBy)
        {
            SQLiteDatabase db = this.ReadableDatabase;
            ICursor karetka = db.Query(Osoba.NazwaTabeli, Osoba.NazwyKolumnTabeli, null, null, null, null, orderBy);
            List<Osoba> lista = new List<Osoba>();
            while (karetka.MoveToNext())
            {
                lista.Add(osobaZKaretki(karetka));
            }
            karetka.Close();
            Osoba[] tablica = lista.ToArray();
            return tablica;
        }

        public Osoba[] PobierzWszystkieRekordy()
        {
            return PobierzWszystkieRekordy(null);
        }

        public bool UsuńRekord(int id)
        {
            SQLiteDatabase db = WritableDatabase;
            string[] whereArgs = { id.ToString() };
            return db.Delete(Osoba.NazwaTabeli, "Id=?", whereArgs) > 0;
        }

        public bool ZmieńRekord(int id, Osoba osoba)
        {
            SQLiteDatabase db = WritableDatabase;
            ContentValues wartości = wartościZOsoby(osoba);
            string[] whereArgs = { id.ToString() };
            return db.Update(Osoba.NazwaTabeli, wartości, "Id=?", whereArgs) > 0;
        }
    }
}