﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;
using System.Collections.Generic;
using Android.Content.PM;
using Android.Content;

namespace Kontakty
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        private ListView listView;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            if (Build.VERSION.SdkInt >= Android.OS.BuildVersionCodes.M && this.CheckSelfPermission(Android.Manifest.Permission.WriteContacts) != Permission.Granted)
            {
                this.RequestPermissions(new string[] { Android.Manifest.Permission.WriteContacts }, PERMISSIONS_REQUEST_WRITE_CONTACTS);
            }
            else
            {
                addContacts();
            }

            if (Build.VERSION.SdkInt >= Android.OS.BuildVersionCodes.M && this.CheckSelfPermission(Android.Manifest.Permission.ReadContacts) != Permission.Granted)
            {
                this.RequestPermissions(new string[] { Android.Manifest.Permission.ReadContacts }, PERMISSIONS_REQUEST_READ_CONTACTS);
                //After this point you wait for callback in onRequestPermissionsResult(int, String[], int[]) overriden method
            }
            else
            {
                // Android version is lesser than 6.0 or the permission is already granted.
                showContacts();
            }

            if (Build.VERSION.SdkInt >= Android.OS.BuildVersionCodes.M && this.CheckSelfPermission(Android.Manifest.Permission.CallPhone) != Permission.Granted)
            {
                this.RequestPermissions(new string[] { Android.Manifest.Permission.CallPhone }, PERMISSIONS_REQUEST_CALL_PHONE);
                Toast.MakeText(this, "Wystąpienie o zgodę na inicjowanie połączeń", ToastLength.Short).Show();
            }
            else
            {
                //Toast.MakeText(this, "Zgoda na inicjowanie połączeń została uzyskana wcześniej", ToastLength.Short).Show();
            }
        }

        private void addContacts()
        {
            Kontakt.UsuńWszystkieKontakty(ContentResolver);
            try
            {
                new Kontakt(
                        "Jacek Matulewski", "+48600123456", null, "+48(56)6113310",
                        "jacek@fizyka.umk.pl", "UMK", "Dr").Zapisz(ContentResolver);
                new Kontakt(
                        "Jan Kowalski", "+48600987654", "11111111", "+48(56)1111111",
                        "jankowalski@firma.pl", "AAAAA", null).Zapisz(ContentResolver);
            }
            catch (Java.Lang.Exception exc)
            {
                Toast.MakeText(ApplicationContext,
                        "Nie udało się dodać kontaktu (" + exc.Message + ")",
                        ToastLength.Long).Show();
            }
        }

        private void showContacts()
        {
            //dane dla listy
            //List<string> lista = Kontakt.ListaNazwWszystkichKontaktow(this.ContentResolver);
            List<string> lista = Kontakt.ListaOpisowWszystkichKontaktow(this.ContentResolver);
            if (lista == null)
            {
                TextView naglowek = FindViewById<TextView>(Resource.Id.naglowek);
                naglowek.Text = "Brak zdefiniowanych kontaktów";
                return;
            }
            ArrayAdapter<string> adapter = new ArrayAdapter<string>(this, Android.Resource.Layout.SimpleListItem1, lista);

            // kontrolka
            listView = FindViewById<ListView>(Resource.Id.listView);
            listView.Adapter = adapter;

            List<Kontakt> listaKontaktów = Kontakt.ListaWszystkichKontaktow(ContentResolver);

            listView.ItemLongClick +=
                (object sender, AdapterView.ItemLongClickEventArgs e) =>
                {
                    Kontakt kontakt = listaKontaktów[e.Position];

                    Android.App.AlertDialog.Builder adb = new Android.App.AlertDialog.Builder(e.Parent.Context);
                    adb.SetTitle(kontakt.NazwaWyswietlana);
                    string[] etykiety = { "Zadzwoń (tel. kom.)", "Wyślij SMS", "Napisz e-mail", "Anuluj" };
                    adb.SetItems(
                        etykiety,
                        (object _sender, Android.Content.DialogClickEventArgs _e) =>
                        {
                            switch (_e.Which)
                            {
                                case 0:
                                    {
                                        Intent i = new Intent(Intent.ActionCall);
                                        i.SetData(Android.Net.Uri.Parse("tel:" + kontakt.TelefonKomorkowy));
                                        //Finish();
                                        StartActivity(i);
                                    }
                                    break;
                                case 1:
                                    {
                                        string tekst = "Przykładowa treść";
                                        Intent i = new Intent(Intent.ActionSendto, Android.Net.Uri.Parse("smsto:" + kontakt.TelefonKomorkowy));
                                        i.PutExtra("sms_body", tekst);
                                        StartActivity(i);
                                    }
                                    break;
                                case 2:
                                    {
                                        string tekst = "Przykładowa treść";

                                        Intent i = new Intent(Intent.ActionSend);
                                        i.SetType("message/rfc822");
                                        i.PutExtra(Intent.ExtraEmail, new string[] { kontakt.EmailWPracy }); //tu moze byc wielu odbiorcow
                                        i.PutExtra(Intent.ExtraSubject, "Temat listu");
                                        i.PutExtra(Intent.ExtraText, tekst);
                                        try
                                        {
                                            StartActivity(Intent.CreateChooser(i, "Wyślij e-mail..."));
                                        }
                                        catch (Android.Content.ActivityNotFoundException)
                                        {
                                            Toast.MakeText(this, "Brak zainstalowanych aplikacji do wysyłania listów e-mail", ToastLength.Short).Show();
                                        }
                                    }
                                    break;
                                default:
                                case 3:
                                    break;
                            }
                        });

                    Android.App.AlertDialog ad = adb.Create();
                    ad.Show();
                };
        }

        private const int PERMISSIONS_REQUEST_READ_CONTACTS = 100;
        private const int PERMISSIONS_REQUEST_WRITE_CONTACTS = 101;
        private const int PERMISSIONS_REQUEST_CALL_PHONE = 102;

        public override void OnRequestPermissionsResult(int requestCode, string[] permissions, [GeneratedEnum] Permission[] grantResults)
        {
            base.OnRequestPermissionsResult(requestCode, permissions, grantResults);
            switch(requestCode)
            {
                case PERMISSIONS_REQUEST_READ_CONTACTS:
                    if (grantResults[0] == Permission.Granted)
                    {
                        // Permission is granted                    
                        showContacts();
                    }
                    else
                    {
                        Toast.MakeText(this, "Nie można wyświetlać kontaktów do momentu udzielenia zgody", ToastLength.Short).Show();
                    }
                    break;
                case PERMISSIONS_REQUEST_WRITE_CONTACTS:
                    if (grantResults[0] == Permission.Granted)
                    {
                        addContacts();
                        showContacts();
                    }
                    else
                    {
                        Toast.MakeText(this, "Nie można dodawać kontaktów do momentu udzielenia zgody", ToastLength.Short).Show();
                    }
                    break;
                case PERMISSIONS_REQUEST_CALL_PHONE:
                    if (grantResults[0] == Permission.Granted)
                    {
                        Toast.MakeText(this, "Uprawnienie do inicjowania połączeń zostało uzyskane", ToastLength.Short).Show();
                    }
                    else
                    {
                        Toast.MakeText(this, "Nie można inicjować połączeń bez uzyskania zgody", ToastLength.Short).Show();
                    }
                    break;
            }
        }
    }
}