﻿using System.Collections.Generic;

using Android.Content;
using Android.Database;
using Android.Net;
using Android.Provider;

namespace Kontakty
{
    class Kontakt
    {
        public string NazwaWyswietlana;
        public string TelefonKomorkowy;
        public string TelefonDomowy;
        public string TelefonWPracy;
        public string EmailWPracy;
        public string Firma;
        public string Tytul;
        //mozna uzupelnic m.in. o zdjecie

        public Kontakt(
                string nazwaWyswietlana,
                string telefonKomorkowy,
                string telefonDomowy,
                string telefonWPracy,
                string emailWPracy,
                string firma,
                string tytul)
        {
            this.NazwaWyswietlana = nazwaWyswietlana;
            this.TelefonKomorkowy = telefonKomorkowy;
            this.TelefonDomowy = telefonDomowy;
            this.TelefonWPracy = telefonWPracy;
            this.EmailWPracy = emailWPracy;
            this.Firma = firma;
            this.Tytul = tytul;
        }

        public static List<string> ListaNazwWszystkichKontaktow(ContentResolver contentResolver)
        {
            List<string> lista = new List<string>();
            ICursor cursor = contentResolver.Query(ContactsContract.Contacts.ContentUri, null, null, null, null);
            if (cursor.Count > 0)
            {
                while (cursor.MoveToNext())
                {
                    string nazwa = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.DisplayName));
                    string id = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.Id));
                    lista.Add("[" + id + "] " + nazwa);
                }
            }
            else
            {
                lista = null;
            }
            cursor.Close();
            return lista;
        }

        public static void UsuńWszystkieKontakty(ContentResolver contentResolver)
        {
            ICursor cursor = contentResolver.Query(ContactsContract.Contacts.ContentUri, null, null, null, null);
            while (cursor.MoveToNext())
            {
                string klucz = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.LookupKey));
                Uri uri = Uri.WithAppendedPath(ContactsContract.Contacts.ContentLookupUri, klucz);
                contentResolver.Delete(uri, null, null);
            }
            cursor.Close();
        }

        //Zrodlo: http://stackoverflow.com/questions/4744187/how-to-add-new-contacts-in-android
        private static void dodajNowyKontaktDoBazy(ContentResolver contentResolver, Kontakt kontakt)
        {

            List<ContentProviderOperation> dodawanyKontakt = new List<ContentProviderOperation>();

            dodawanyKontakt.Add(ContentProviderOperation.NewInsert(
                ContactsContract.RawContacts.ContentUri)
                    .WithValue(ContactsContract.RawContacts.InterfaceConsts.AccountType, null)
                    .WithValue(ContactsContract.RawContacts.InterfaceConsts.AccountName, null)
                    .Build());

            if (kontakt.NazwaWyswietlana != null)
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                         .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                         .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.StructuredName.ContentItemType)
                         .WithValue(ContactsContract.CommonDataKinds.StructuredName.DisplayName, kontakt.NazwaWyswietlana)
                         .Build());
            }

            if (kontakt.TelefonKomorkowy != null)
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                     .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                     .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.Phone.ContentItemType)
                     .WithValue(ContactsContract.CommonDataKinds.Phone.Number, kontakt.TelefonKomorkowy)
                     //.WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.GetTypeLabelResource(PhoneDataKind.Mobile))
                     .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.InterfaceConsts.TypeCustom)
                     .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Label, "Mobile")
                     .Build());
            }

            if (kontakt.TelefonDomowy != null)
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                     .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                     .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.Phone.ContentItemType)
                     .WithValue(ContactsContract.CommonDataKinds.Phone.Number, kontakt.TelefonDomowy)
                     //.WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.GetTypeLabelResource(PhoneDataKind.Home))
                     .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.InterfaceConsts.TypeCustom)
                     .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Label, "Home")
                     .Build());
            }

            if (kontakt.TelefonWPracy != null)
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                     .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                     .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.Phone.ContentItemType)
                     .WithValue(ContactsContract.CommonDataKinds.Phone.Number, kontakt.TelefonWPracy)
                     //.WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.GetTypeLabelResource(PhoneDataKind.Work))                     
                     .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.InterfaceConsts.TypeCustom)
                     .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Label, "Work")
                     .Build());
            }

            if (kontakt.EmailWPracy != null)
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                     .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                     .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.Email.ContentItemType)
                     .WithValue(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Data, kontakt.EmailWPracy)
                     //.WithValue(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Email.GetTypeLabelResource(EmailDataKind.Work))
                     .WithValue(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.InterfaceConsts.TypeCustom)
                     .WithValue(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Label, "Work")
                     .Build());
            }

            if (string.IsNullOrEmpty(kontakt.Firma) && string.IsNullOrEmpty(kontakt.Tytul))
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                     .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                     .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.Organization.ContentItemType)
                     .WithValue(ContactsContract.CommonDataKinds.Organization.Company, kontakt.Firma)
                     //.WithValue(ContactsContract.CommonDataKinds.Organization.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Organization.GetTypeLabelResource(OrganizationDataKind.Work))
                     .WithValue(ContactsContract.CommonDataKinds.Organization.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.InterfaceConsts.TypeCustom)
                     .WithValue(ContactsContract.CommonDataKinds.Organization.InterfaceConsts.Label, "Work")
                     .WithValue(ContactsContract.CommonDataKinds.Organization.Title, kontakt.Tytul)
                     //.WithValue(ContactsContract.CommonDataKinds.Organization.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Organization.GetTypeLabelResource(OrganizationDataKind.Work))
                     .WithValue(ContactsContract.CommonDataKinds.Organization.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.InterfaceConsts.TypeCustom)
                     .WithValue(ContactsContract.CommonDataKinds.Organization.InterfaceConsts.Label, "Work")
                     .Build());
            }

            //prosba do dostawcy kontaktaktow o utworzenie nowego kontaktu
            //try 
            //{
            contentResolver.ApplyBatch(ContactsContract.Authority, dodawanyKontakt);
            //return true;
            //} 
            //catch (Exception e) 
            //{
            //e.printStackTrace();
            //return false;
            //} 
        }

        public void Zapisz(ContentResolver contentResolver)
        {
            dodajNowyKontaktDoBazy(contentResolver, this);
        }

        private static Kontakt odczytajKontaktZBazyDanych(ContentResolver contentResolver, ICursor cursor)
        {
            string id = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.Id));
            string nazwaWyświetlana = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.DisplayName));
            string telefonKomórkowy = "", telefonDomowy = "", telefonWPracy = "", emailWPracy = "", firma = "", tytuł = "";

            if (int.Parse(cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.HasPhoneNumber))) > 0)
            {
                ICursor numeryTelefonow = contentResolver.Query(ContactsContract.CommonDataKinds.Phone.ContentUri, null, ContactsContract.CommonDataKinds.Phone.InterfaceConsts.ContactId + " = " + id, null, null);
                while (numeryTelefonow.MoveToNext())
                {
                    string numer = numeryTelefonow.GetString(numeryTelefonow.GetColumnIndex(ContactsContract.CommonDataKinds.Phone.Number));
                    string typNumeru = numeryTelefonow.GetString(numeryTelefonow.GetColumnIndex(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Label));
                    switch (typNumeru)
                    {
                        case "Mobile":
                            telefonKomórkowy = numer;
                            break;
                        case "Home":
                            telefonDomowy = numer;
                            break;
                        case "Work":
                            telefonWPracy = numer;
                            break;
                    }
                }
                numeryTelefonow.Close();
            }

            ICursor adresyEmail = contentResolver.Query(ContactsContract.CommonDataKinds.Email.ContentUri, null, ContactsContract.CommonDataKinds.Email.InterfaceConsts.ContactId + " = " + id, null, null);
            while (adresyEmail.MoveToNext())
            {
                string adresEmail = adresyEmail.GetString(adresyEmail.GetColumnIndex(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Data));
                string typAdresu = adresyEmail.GetString(adresyEmail.GetColumnIndex(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Label));
                if (typAdresu == "Work")
                {
                    emailWPracy = adresEmail;
                    break; //przerwanie petli while
                }
            }
            adresyEmail.Close();

            //organizacja
            string where = ContactsContract.Data.InterfaceConsts.ContactId + " = ? AND " + ContactsContract.Data.InterfaceConsts.Mimetype + " = ?";
            string[] whereParams = new string[]
            {
             id,
             ContactsContract.CommonDataKinds.Organization.ContentItemType
            };
            ICursor organizacje = contentResolver.Query(ContactsContract.Data.ContentUri, null, where, whereParams, null);
            if (organizacje.MoveToFirst())
            {
                firma = organizacje.GetString(organizacje.GetColumnIndex(ContactsContract.CommonDataKinds.Organization.InterfaceConsts.Data));
                tytuł = organizacje.GetString(organizacje.GetColumnIndex(ContactsContract.CommonDataKinds.Organization.Title));
            }
            organizacje.Close();

            return new Kontakt(nazwaWyświetlana, telefonKomórkowy, telefonDomowy, telefonWPracy, emailWPracy, firma, tytuł);
        }

        public static List<Kontakt> ListaWszystkichKontaktow(ContentResolver contentResolver)
        {
            List<Kontakt> lista = new List<Kontakt>();
            ICursor cursor = contentResolver.Query(ContactsContract.Contacts.ContentUri, null, null, null, null);
            if (cursor.Count > 0)
            {
                while (cursor.MoveToNext())
                {
                    Kontakt kontakt = odczytajKontaktZBazyDanych(contentResolver, cursor);
                    lista.Add(kontakt);
                }
            }
            else
            {
                lista = null;
            }
            return lista;
        }

        public static List<string> ListaOpisowWszystkichKontaktow(ContentResolver contentResolver)
        {
            List<Kontakt> listaKontaktow = Kontakt.ListaWszystkichKontaktow(contentResolver);
            List<string> lista = new List<string>();
            foreach (Kontakt kontakt in listaKontaktow)
            {
                string opis =
                        kontakt.Tytul + " " + kontakt.NazwaWyswietlana +
                        "\ntel. kom.:" + kontakt.TelefonKomorkowy +
                        "\ne-mail:" + kontakt.EmailWPracy;
                lista.Add(opis.Trim());
            }
            return lista;
        }
    }
}