﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.Media;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;

namespace Uslugi
{
    [Service] //<--- !!!!!!!!!!!!!!!
    class Usluga : Service
    {
        public static bool CzyUtworzona { get; private set; } = false;

        public override IBinder OnBind(Intent intent)
        {
            return null;
        }

        private Java.Util.Timer timer;
        private static Toast toastDlaTimera;

        class TickingTask : Java.Util.TimerTask
        {
            public override void Run()
            {
                //string czas = DateTime.Now.ToLongTimeString();
                //toastDlaTimera.SetText("Usługa: " + czas);
                //toastDlaTimera.Show();
                //wątki (inne niż UI thread) nie mogą dotykać widoku (w tym toast) 
                //UWAGA! Ten problem będzie omawiany w następnej lekcji

                ToneGenerator toneG = new ToneGenerator(Stream.Alarm, 100);
                toneG.StartTone(Tone.CdmaAlertCallGuard, 200);
            }
        }

        public override void OnCreate()
        {
            base.OnCreate();

            toastDlaTimera = Toast.MakeText(ApplicationContext, "", ToastLength.Short);

            timer = new Java.Util.Timer();            
            timer.ScheduleAtFixedRate( //do domu: zmienić na Timer z .NET
                new TickingTask(), 1000, 2000); //co 2s po 1s

            CzyUtworzona = true;
            Toast.MakeText(ApplicationContext, "Usługa utworzona", ToastLength.Short).Show();
        }

        public override void OnDestroy()
        {
            timer.Cancel();
            CzyUtworzona = false;
            Toast.MakeText(ApplicationContext, "Usługa zatrzymana", ToastLength.Short).Show();
            base.OnDestroy();
        }

        [return: GeneratedEnum]
        public override StartCommandResult OnStartCommand(Intent intent, [GeneratedEnum] StartCommandFlags flags, int startId)
        {
            Toast.MakeText(ApplicationContext, "Usługa uruchomiona", ToastLength.Short).Show();
            return base.OnStartCommand(intent, flags, startId);
        }
    }
}