﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;
using Android.Content;

namespace Uslugi
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        private Button button1, button2;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            button1 = FindViewById<Button>(Resource.Id.button1);
            button2 = FindViewById<Button>(Resource.Id.button2);
            button1.Click += 
                (object sender, System.EventArgs e) => 
                {
                    if (!Usluga.CzyUtworzona)
                    {
                        Toast.MakeText(ApplicationContext, "Uruchamiam usługę", ToastLength.Short).Show();
                        StartService(new Intent(this, typeof(Usluga)));
                    }
                    else Toast.MakeText(ApplicationContext, "Usługa jest już uruchomiona", ToastLength.Short).Show();
                };
            button2.Click += 
                (object sender, System.EventArgs e) => 
                {
                    if (Usluga.CzyUtworzona)
                    {
                        Toast.MakeText(ApplicationContext, "Zatrzymuję usługę", ToastLength.Short).Show();
                        StopService(new Intent(this, typeof(Usluga)));
                    }
                    else Toast.MakeText(ApplicationContext, "Usługa nie jest uruchomiona", ToastLength.Short).Show();
                };
        }
    }
}