﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;
using Android.Content;

namespace Powiadomienia
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        private EditText tytuł, treść;
        private Button pokaż, ukryj;
        private const int idPowiadomienia = 0;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            tytuł = FindViewById<EditText>(Resource.Id.tytul);
            treść = FindViewById<EditText>(Resource.Id.tresc);

            pokaż = FindViewById<Button>(Resource.Id.pokaz);
            pokaż.Click += Pokaż_Click;

            ukryj = FindViewById<Button>(Resource.Id.ukryj);
            ukryj.Click += Ukryj_Click;
        }

        private void Pokaż_Click(object sender, System.EventArgs e)
        {
            Toast.MakeText(ApplicationContext, treść.Text, ToastLength.Long).Show();

            //Czynnosc wykonywana po "tapnieciu" powiadomienia = pokazanie tej aktywności (nowej instancji)
            Intent i = new Intent(ApplicationContext, typeof(MainActivity));
            PendingIntent pi = PendingIntent.GetActivity(ApplicationContext, 0, i, 0);

            //menedzer
            NotificationManager nm = (NotificationManager)GetSystemService(NotificationService);

            //API >=26
            string channelId = "kanał";
            nm.CreateNotificationChannel(new NotificationChannel(channelId, "KanałUMK", NotificationImportance.Default));            

            //Zbuduj budowniczego powiadomienia
            //Notification.Builder nb = new Notification.Builder(ApplicationContext); //starsze API
            Notification.Builder nb = new Notification.Builder(ApplicationContext, channelId); //nowe API, potrzebny emulator z Android 8
            nb.SetSmallIcon(Resource.Mipmap.ic_launcher);
            nb.SetContentTitle(tytuł.Text);
            nb.SetContentText(treść.Text);
            nb.SetContentIntent(pi);
            //nb.AddAction(Resource.Mipmap.ic_launcher_round, "Uruchom akcję", pi);
            //nb.AddAction(Resource.Mipmap.ic_launcher_round, "Uruchom akcję 2", pi);

            //pokaz powiadomienie
            Notification n = nb.Build();
            n.Flags |= NotificationFlags.AutoCancel;

            nm.Notify(idPowiadomienia, n);
        }

        private void Ukryj_Click(object sender, System.EventArgs e)
        {
            NotificationManager nm = (NotificationManager)GetSystemService(NotificationService);
            nm.Cancel(idPowiadomienia);
        }
    }
}