﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.Graphics;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;

namespace StanUrzadzenia
{
    public enum TypInformacji { StanUrzadzenia, Czujnik, Inne };
    public class UrządzenieInfo
    {
        public TypInformacji typInformacji;
        public string nazwa;
        public int polozeniePaska;
        public string opis;
    }

    public class UrzadzeniaAdapter : ArrayAdapter<UrządzenieInfo>
    {
        private List<UrządzenieInfo> items;

        public UrzadzeniaAdapter(Context context, int textViewResourceId, List<UrządzenieInfo> items)
                : base(context, textViewResourceId, items)
        {
            this.items = items;
        }

        private static Color kolorDlaTypuInformacji(TypInformacji typInformacji)
        {
            Color kolor = Color.White;
            switch (typInformacji)
            {
                case TypInformacji.StanUrzadzenia:
                    kolor = Color.Yellow;
                    break;
                case TypInformacji.Czujnik:
                    kolor = Color.Green;
                    break;
                default:
                case TypInformacji.Inne:
                    kolor = Color.White;
                    break;
            }
            return kolor;
        }

        public override View GetView(int position, View convertView, ViewGroup parent)
        {
            View v = convertView;
            if (v == null)
            {
                LayoutInflater vi = (LayoutInflater)this.Context.GetSystemService(Context.LayoutInflaterService);
                v = vi.Inflate(Resource.Layout.wiersz, null);
            }
            UrządzenieInfo o = items[position];
            if (o != null)
            {
                TextView nazwa = v.FindViewById<TextView>(Resource.Id.nazwa);
                if (nazwa != null) nazwa.Text = o.nazwa;
                nazwa.SetTextColor(kolorDlaTypuInformacji(o.typInformacji));

                ProgressBar pasek = v.FindViewById<ProgressBar>(Resource.Id.pasek);
                pasek.SetProgress((o.polozeniePaska == -1) ? 0 : o.polozeniePaska, false); //bez animacji, bo cyklicznie odświeżane

                TextView opis = v.FindViewById<TextView>(Resource.Id.opis);
                if (opis != null) opis.Text = o.opis;
            }
            return v;
        }
    }
}