﻿using Android.App;
using Android.Widget;
using Android.OS;
using Android.Support.V7.App;
using Android.Graphics; //<------
using Android.Graphics.Drawables.Shapes;
using Android.Graphics.Drawables;
using Android.Preferences;
using Android.Content;

namespace Kolory
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        //pola
        private TextView etykieta_panel; //Label, pełni też rolę panela
        private SeekBar seekBarR, seekBarG, seekBarB; //TrackBar

        private Spinner spinner; //ComboBox
        private bool czyUstawicSpinnerNaSuwaki = true;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);

            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            etykieta_panel = (TextView)FindViewById(Resource.Id.etykieta_panel);
            seekBarR = (SeekBar)FindViewById(Resource.Id.seekBarR);
            seekBarG = (SeekBar)FindViewById(Resource.Id.seekBarG);
            seekBarB = (SeekBar)FindViewById(Resource.Id.seekBarB);

            seekBarR.ProgressChanged += SeekBar_ProgressChanged;
            seekBarG.ProgressChanged += SeekBar_ProgressChanged;
            seekBarB.ProgressChanged += SeekBar_ProgressChanged;

            //konfigurowanie suwaków z poziomu kodu
            float promien = 8;
            float[] zewnetrznePromienie = new float[] { promien, promien, promien, promien, promien, promien, promien, promien };
            RoundRectShape rrs = new RoundRectShape(zewnetrznePromienie, null, null);
            ShapeDrawable sdR = new ShapeDrawable(rrs);
            sdR.Paint.SetShader(new LinearGradient(0, 0, 200, 0, Color.Black, Color.Red, Shader.TileMode.Clamp));
            seekBarR.ProgressDrawable = sdR;
            ShapeDrawable sdG = new ShapeDrawable(rrs);
            sdG.Paint.SetShader(new LinearGradient(0, 0, 200, 0, Color.Black, Color.Green, Shader.TileMode.Clamp));
            seekBarG.ProgressDrawable = sdG;
            ShapeDrawable sdB = new ShapeDrawable(rrs);
            sdB.Paint.SetShader(new LinearGradient(0, 0, 200, 0, Color.Black, Color.Blue, Shader.TileMode.Clamp));
            seekBarB.ProgressDrawable = sdB;

            //rozwijana lista
            spinner = (Spinner)FindViewById(Resource.Id.spinner);
            ArrayAdapter adapter = ArrayAdapter.CreateFromResource(
                    this, Resource.Array.kolory, Android.Resource.Layout.SimpleSpinnerItem);
            adapter.SetDropDownViewResource(Android.Resource.Layout.SimpleSpinnerDropDownItem);
            spinner.Adapter = adapter;
            spinner.ItemSelected += Spinner_ItemSelected;

            //spinner.SetSelection(9);
            if (!odtworzStan()) spinner.SetSelection(9);
        }

        private void Spinner_ItemSelected(object sender, AdapterView.ItemSelectedEventArgs e)
        {
            czyUstawicSpinnerNaSuwaki = false;

            switch (e.Position)
            {
                case 0:
                    break;
                case 1: //czarny
                    seekBarR.Progress = 0;
                    seekBarG.Progress = 0;
                    seekBarB.Progress = 0;
                    break;
                case 2: //biały
                    seekBarR.Progress = 255;
                    seekBarG.Progress = 255;
                    seekBarB.Progress = 255;
                    break;
                case 3: //czerwony
                    seekBarR.Progress = 255;
                    seekBarG.Progress = 0;
                    seekBarB.Progress = 0;
                    break;
                case 4: //zielony
                    seekBarR.Progress = 0;
                    seekBarG.Progress = 255;
                    seekBarB.Progress = 0;
                    break;
                case 5: //niebieski
                    seekBarR.Progress = 0;
                    seekBarG.Progress = 0;
                    seekBarB.Progress = 255;
                    break;
                case 6: //turkusowy
                    seekBarR.Progress = 0;
                    seekBarG.Progress = 255;
                    seekBarB.Progress = 255;
                    break;
                case 7: //purpurowy
                    seekBarR.Progress = 255;
                    seekBarG.Progress = 0;
                    seekBarB.Progress = 255;
                    break;
                case 8: //żółty
                    seekBarR.Progress = 255;
                    seekBarG.Progress = 255;
                    seekBarB.Progress = 0;
                    break;
                case 9: //szary
                    seekBarR.Progress = 127;
                    seekBarG.Progress = 127;
                    seekBarB.Progress = 127;
                    break;
            }

            czyUstawicSpinnerNaSuwaki = true;
        }

        private void SeekBar_ProgressChanged(object sender, SeekBar.ProgressChangedEventArgs e)
        {
            int r = seekBarR.Progress;
            int g = seekBarG.Progress;
            int b = seekBarB.Progress;

            etykieta_panel.SetBackgroundColor(Color.Argb(255, r, g, b));
            etykieta_panel.SetText(
                    "Składowe koloru: " +
                    r.ToString("X2").ToUpper() + " " +
                    g.ToString("X2").ToUpper() + " " +
                    b.ToString("X2").ToUpper() + " ", TextView.BufferType.Normal);

            int jasnosc = (r + g + b) / 3;
            if (jasnosc > 127) etykieta_panel.SetTextColor(Color.Black);
            else etykieta_panel.SetTextColor(Color.White);

            if (czyUstawicSpinnerNaSuwaki) spinner.SetSelection(0);
        }

        #region Ustawienia
        private void zapiszStan()
        {

            ISharedPreferencesEditor edytorUstawien = PreferenceManager.GetDefaultSharedPreferences(this).Edit();
            edytorUstawien.PutInt("SkladowaR", seekBarR.Progress);
            edytorUstawien.PutInt("SkladowaG", seekBarG.Progress);
            edytorUstawien.PutInt("SkladowaB", seekBarB.Progress);
            edytorUstawien.Commit();
        }

        private bool odtworzStan()
        {
            ISharedPreferences ustawienia = PreferenceManager.GetDefaultSharedPreferences(this);
            seekBarR.Progress = ustawienia.GetInt("SkladowaR", 0);
            seekBarG.Progress = ustawienia.GetInt("SkladowaG", 0);
            seekBarB.Progress = ustawienia.GetInt("SkladowaB", 0);
            return ustawienia.Contains("SkladowaR") && ustawienia.Contains("SkladowaG") && ustawienia.Contains("SkladowaB");
        }
        #endregion

        protected override void OnPause()
        {
            base.OnPause();
            zapiszStan();
        }
    }
}

