﻿using Android.App;
using Android.Widget;
using Android.OS;
using Android.Support.V7.App;
using Android.Views;

namespace HelloWorld
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        private Button przycisk;
        private TextView etykieta;
        private ListView lista;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);

            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            przycisk = (Button)FindViewById(Resource.Id.button1);
            //przycisk.Click += (object sender, System.EventArgs e) => { Toast.MakeText(this, "Hello World!", ToastLength.Long).Show(); };

            etykieta = (TextView)FindViewById(Resource.Id.textView1);
            lista = (ListView)FindViewById(Resource.Id.listView1);

            string[] łańcuchy = new string[]
            {
                "tekst1",
                "tekst2",
                "tekst3",
                "tekst4"
            };
            ArrayAdapter<string> adapter = new ArrayAdapter<string>(this, Android.Resource.Layout.SimpleListItem1, łańcuchy);
            lista.Adapter = adapter;

            lista.ItemClick += Lista_ItemClick;
        }

        [Java.Interop.Export("przycisk_onClick")]
        public void przycisk_onClick(View v)
        {
            Toast.MakeText(this, "Hello World!", ToastLength.Long).Show();
        }

        private void Lista_ItemClick(object sender, AdapterView.ItemClickEventArgs e)
        {
            Toast.MakeText(this, "Kliknięta pozycja " + e.Position + " (" + (e.View as TextView).Text + ")", ToastLength.Long).Show();
        }
    }
}

