using System.Threading.Tasks;
using MvvmCross.Core.ViewModels;
using Kolory.Core.Models;
using MvvmCross.Platform.UI;

namespace Kolory.Core.ViewModels
{
    public class MainViewModel : MvxViewModel
    {
        private Color _color;

        public MainViewModel()
        {
            _color = new Color(0, 0, 0);
        }

        public IMvxCommand ResetColorCommand => new MvxCommand(ResetColor);

        private void ResetColor()
        {
            var mvxColor = new MvxColor(1, 1, 1);
            mvxColor.A = 1;
            R = 0;
            G = 0;
            B = 0;
        }

        public byte R
        {
            get { return _color.R; }
            set
            {
                _color.R = value;
                RaisePropertyChanged("R");
                RaisePropertyChanged("CurrentColor");
            }
        }

        public byte G
        {
            get { return _color.G; }
            set
            {
                _color.G = value;
                RaisePropertyChanged("G");
                RaisePropertyChanged("CurrentColor");
            }
        }

        public byte B
        {
            get { return _color.B; }
            set
            {
                _color.B = value;
                RaisePropertyChanged("B");
                RaisePropertyChanged("CurrentColor");
            }
        }

        public MvxColor CurrentColor { get => new MvxColor(_color.R, _color.G, _color.B); set { CurrentColor = value; } }

    }
}