﻿using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.WindowsCE.Forms;

namespace SmartDeviceProject1
{
    public partial class Form1 : Form
    {
        Color kolorRysika = Color.Black;
        Bitmap bmp;
        Graphics g;

        int rozmiarPunktu = 4;

        Point poprzedniePolozenieRysika;
        Pen p = new Pen(Color.Red);

        MenuItem wybranyKolor;

        public Form1()
        {
            InitializeComponent();

            bmp = new Bitmap(
                pictureBox1.Width, 
                pictureBox1.Height);

            g = Graphics.FromImage(bmp);
            g.Clear(Color.White);
            pictureBox1.Image = bmp;

            //przycisk
            try
            {
                hardwareButton1.AssociatedControl = this;
                hardwareButton1.HardwareKey = HardwareKeys.ApplicationKey1;
            }
            catch (Exception exc)
            {
                MessageBox.Show("Nie można skonfigurować obsługi przycisków: " + exc.Message);
            }

            wybranyKolor = menuItem7;
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        private void menuItem3_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void pictureBox1_MouseDown(object sender, MouseEventArgs e)
        {            
            g.FillEllipse(new SolidBrush(Color.Black), e.X - rozmiarPunktu / 2, e.Y - rozmiarPunktu / 2, rozmiarPunktu, rozmiarPunktu);
            g.DrawEllipse(p, e.X - rozmiarPunktu / 2, e.Y - rozmiarPunktu / 2, rozmiarPunktu, rozmiarPunktu);

            //pictureBox1.Image = bmp;
            pictureBox1.Refresh();

            poprzedniePolozenieRysika = new Point(e.X, e.Y);
        }

        private void pictureBox1_MouseMove(object sender, MouseEventArgs e)
        {
            g.DrawLine(
                p, 
                poprzedniePolozenieRysika.X, 
                poprzedniePolozenieRysika.Y, 
                e.X, 
                e.Y);

            pictureBox1.Refresh();

            poprzedniePolozenieRysika = new Point(e.X, e.Y);
        }

        private void menuItem7_Click(object sender, EventArgs e)
        {
            wybranyKolor=sender as MenuItem;
            
            foreach (MenuItem elementMenu in menuItem2.MenuItems) 
                elementMenu.Checked = false;
            wybranyKolor.Checked = true;

            switch (wybranyKolor.Text)
            {
                case "Cyjan": kolorRysika = Color.Cyan; break;
                case "Biskupi": kolorRysika = Color.Magenta; break;
                case "Żółty": kolorRysika = Color.Yellow; break;
                case "Czerwony": kolorRysika = Color.Red; break;
                case "Zielony": kolorRysika = Color.Green; break;
                case "Niebieski": kolorRysika = Color.Blue; break;
                default: kolorRysika = Color.Black; break;
            }

            p.Color = kolorRysika;
        }

        private void menuItem11_Click(object sender, EventArgs e)
        {
            string rozszerzenie = ".jpeg";
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                if (!saveFileDialog1.FileName.EndsWith(rozszerzenie)) 
                    saveFileDialog1.FileName += rozszerzenie;
                pictureBox1.Image.Save(
                    saveFileDialog1.FileName, 
                    System.Drawing.Imaging.ImageFormat.Bmp);
            }
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            this.Text = e.KeyCode.ToString()+" "+e.KeyValue.ToString();

            int indeksKolor=menuItem2.MenuItems.IndexOf(wybranyKolor);

            if ((e.KeyCode == System.Windows.Forms.Keys.Up))
            {
                // Up
                if(indeksKolor>0)
                    wybranyKolor = menuItem2.MenuItems[indeksKolor - 1];
            }
            if ((e.KeyCode == System.Windows.Forms.Keys.Down))
            {
                // Down
                if(indeksKolor<menuItem2.MenuItems.Count-1)
                    wybranyKolor = menuItem2.MenuItems[indeksKolor + 1];
            }
            this.Text = "Nowy kolor: "+wybranyKolor.Text;
            menuItem7_Click(wybranyKolor, new EventArgs());            


            if ((e.KeyCode == System.Windows.Forms.Keys.Left))
            {
                // Left
            }
            if ((e.KeyCode == System.Windows.Forms.Keys.Right))
            {
                // Right
            }
            if ((e.KeyCode == System.Windows.Forms.Keys.Enter))
            {
                // Enter
            }

        }
    }
}