﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.WindowsMobile.PocketOutlook;
using Microsoft.WindowsMobile.Forms;

namespace SMS
{
    public partial class Form1 : Form
    {
        bool zamknijPoWyslaniu = false;
        string numerAdresata;

        public Form1(string numerTelefonu)
        {
            InitializeComponent();

            this.numerAdresata = numerTelefonu;
            sprawdzKontakt(numerTelefonu);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            ChooseContactDialog ccd = new ChooseContactDialog();
            ccd.RequiredProperties = new ContactProperty[] 
                { ContactProperty.Sms };
            ccd.Title = "Wybierz kontakt (SMS)";
            if (ccd.ShowDialog() == DialogResult.OK)
            {
                numerAdresata = ccd.SelectedPropertyValue;
                textBox1.Text = ccd.SelectedContactName
                    + " <" + numerAdresata + ">";
            }
            menuItem1.Enabled = true;
        }

        private void menuItem3_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void menuItem1_Click(object sender, EventArgs e)
        {
            SmsMessage sms = new SmsMessage(
                numerAdresata,
                textBox2.Text);
            sms.RequestDeliveryReport = menuItem5.Checked;

            try
            {
                sms.Send();
                MessageBox.Show("Wiadomość SMS została wysłana");
                if (zamknijPoWyslaniu) Close();
            }
            catch(Exception exc)
            {
                MessageBox.Show("Nie udało się wysłać wiadomości - " + exc.Message);
            }
        }

        private void menuItem5_Click(object sender, EventArgs e)
        {
            menuItem5.Checked = !menuItem5.Checked;
        }

        public void sprawdzKontakt(string numerTelefonu)
        {
            if (numerTelefonu == null || numerTelefonu == "") return;

            OutlookSession os = new OutlookSession();
            var kontakty = from Contact kontakt in os.Contacts.Items
                           where kontakt.MobileTelephoneNumber==numerTelefonu
                           select kontakt.FirstName + " " + kontakt.LastName + " <" + kontakt.MobileTelephoneNumber + ">";
            if (kontakty.Count() == 0) textBox1.Text = numerTelefonu;
            else textBox1.Text = kontakty.First();
            menuItem1.Enabled = true;
            zamknijPoWyslaniu = true;
        }
    }
}