﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.WindowsMobile.PocketOutlook;
using Microsoft.WindowsMobile.Telephony;

namespace Kontakty
{
    public partial class Form1 : Form
    {
        OutlookSession os = new OutlookSession();

        public Form1()
        {
            InitializeComponent();
            dataGrid1.DataSource = os.Contacts.Items;
        }

        private void menuItem1_Click(object sender, EventArgs e)
        {
            Contact kontakt = os.Contacts.Items.AddNew();
            kontakt.FirstName = "Jan";
            kontakt.LastName = "Kowalski";
            kontakt.MobileTelephoneNumber = "7272020";
            kontakt.Email1Address = "jankow@wp.pl";
            kontakt.BusinessTelephoneNumber = "7272024";
            kontakt.Update();

            kontakt = os.Contacts.Items.AddNew();
            kontakt.FirstName = "Maria";
            kontakt.LastName = "Kowalska";
            kontakt.MobileTelephoneNumber = "7272021";
            kontakt.Email1Address = "markow@wp.pl";
            kontakt.BusinessTelephoneNumber = "7272022";
            kontakt.Update();

            kontakt = os.Contacts.Items.AddNew();
            kontakt.FirstName = "Michał";
            kontakt.LastName = "Stokłosa";
            kontakt.MobileTelephoneNumber = "1234567894234";
            kontakt.Email1Address = "misto@wp.pl";
            kontakt.BusinessTelephoneNumber = "0987654234342";
            kontakt.Update();

            dataGrid1.Refresh();
        }

        private void menuItem3_Click(object sender, EventArgs e)
        {
            Contact kontakt = new Contact();
            string orgFileAs = kontakt.FileAs;
            kontakt.ShowDialog();
            if (kontakt.FileAs != orgFileAs)
                os.Contacts.Items.Add(kontakt);
        }

        private void menuItem5_Click(object sender, EventArgs e)
        {
            new Phone().Talk(
                os.Contacts.Items[
                    dataGrid1.CurrentCell.RowNumber]
                        .MobileTelephoneNumber);
        }

        static string KatalogAplikacji
        {
            get
            {
                string katalog = System.IO.Path.GetDirectoryName(
                    System.Reflection.Assembly.
                        GetExecutingAssembly().GetName().CodeBase);
                if (katalog.StartsWith("file:")) katalog.Remove(0, 6);
                return katalog;
            }
        }

        private void menuItem6_Click(object sender, EventArgs e)
        {
            Contact kontakt = os.Contacts.Items[dataGrid1.CurrentCell.RowNumber];
            string numerTelefonu = kontakt.MobileTelephoneNumber;
            if (numerTelefonu == "")
            {
                MessageBox.Show("Wybrany kontakt nie ma numeru telefonu komórkowego");
                return;
            }
            else
            {
                string sciezkaDoExe = 
                    System.IO.Path.Combine(KatalogAplikacji, "SMS.exe");
                //System.Diagnostics.ProcessStartInfo psi = new System.Diagnostics.ProcessStartInfo(sciezkaDoExe, numerTelefonu);
                System.Diagnostics.Process.Start(sciezkaDoExe,numerTelefonu);
            }
        }

        private void menuItem7_Click(object sender, EventArgs e)
        {
            Contact kontakt = os.Contacts.Items[dataGrid1.CurrentCell.RowNumber];
            string adresEmail = kontakt.Email1Address;
            if (adresEmail == "") adresEmail = kontakt.Email2Address;
            if (adresEmail == "") adresEmail = kontakt.Email3Address;
            if (adresEmail == "")
            {
                MessageBox.Show("Wybrany kontakt nie ma adresu poczty elektronicznej");
                return;
            }
            else
            {
                string sciezkaDoExe =
                    System.IO.Path.Combine(KatalogAplikacji, "Email.exe");
                //System.Diagnostics.ProcessStartInfo psi = new System.Diagnostics.ProcessStartInfo(sciezkaDoExe, numerTelefonu);
                System.Diagnostics.Process.Start(sciezkaDoExe, adresEmail);
            }
        }
    }
}