﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.WindowsMobile.PocketOutlook;
using Microsoft.WindowsMobile.Forms;

namespace Email
{
    public partial class Form1 : Form
    {
        OutlookSession os = new OutlookSession();

        EmailAccount wybraneKonto = null;

        void wyborKonta(object sender, EventArgs e)
        {
            MenuItem wybranyElement = sender as MenuItem;
            wybranyElement.Checked = true;
            wybraneKonto = os.EmailAccounts[wybranyElement.Text];
            foreach (MenuItem element in menuItem8.MenuItems)
                if (element != wybranyElement) element.Checked = false;
        }

        public Form1(string adresEmail)
        {
            InitializeComponent();
            var konta = from EmailAccount konto in os.EmailAccounts
                        select konto.Name;
            konta.ToList().ForEach(
                (i) =>
                {
                    MenuItem emk = new MenuItem();
                    emk.Text = i;
                    emk.Click += new EventHandler(wyborKonta);
                    menuItem8.MenuItems.Add(emk);
                });

            menuItem8.MenuItems[0].Checked = true;
            wyborKonta(menuItem8.MenuItems[0], null);

            if (adresEmail != null && adresEmail != "")
            {
                this.adresEmail = adresEmail;
                sprawdzKontakt(adresEmail);
            }
        }

        public void sprawdzKontakt(string adresEmail)
        {
            if (adresEmail == null || adresEmail == "") return;

            var kontakty = from Contact kontakt in os.Contacts.Items
                           where kontakt.Email1Address == adresEmail //pomijam adresy 2 i 3
                           select kontakt.FirstName + " " + kontakt.LastName + " (" + kontakt.Email1Address + ")";
            if (kontakty.Count() == 0) textBox1.Text = adresEmail;
            else textBox1.Text = kontakty.First();
            menuItem1.Enabled = true;
        }

        string adresEmail = "";

        private void button1_Click(object sender, EventArgs e)
        {
            ChooseContactDialog ccd = new ChooseContactDialog();
            ccd.RequiredProperties = new ContactProperty[]
            {
                ContactProperty.AllEmail
            };
            ccd.Title = "Wybierz adresata";
            ccd.ChooseContactOnly = false; //sprawdzic
            if (ccd.ShowDialog() == DialogResult.OK)
            {
                adresEmail = ccd.SelectedPropertyValue;
                textBox1.Text = ccd.SelectedContactName + " (" + adresEmail + ")";
                menuItem1.Enabled = true;
            }
        }

        bool czyJestZalacznik = false;
        string sciezkaZalacznika = "";

        private void menuItem5_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                sciezkaZalacznika = openFileDialog1.FileName;
                label3.Text = sciezkaZalacznika;
                menuItem5.Checked = true;
                menuItem5.Text = "Zmień załącznik...";
                menuItem6.Enabled = true;
                czyJestZalacznik = true;
                MessageBox.Show("Dodałeś załącznik:\n" + sciezkaZalacznika);
            }
        }

        private void menuItem6_Click(object sender, EventArgs e)
        {
            sciezkaZalacznika = "";
            czyJestZalacznik = false;
            label3.Text = "Brak załącznika";
            menuItem5.Checked = false;
            menuItem6.Enabled = false;
            menuItem5.Text = "Dodaj załącznik...";
        }

        private void menuItem1_Click(object sender, EventArgs e)
        {
            //MessageBox.Show("Wysyłam list korzystając z konta " + wybraneKonto.Name);
            EmailMessage email = new EmailMessage();
            email.To.Add(new Recipient(adresEmail));
            email.BodyText = textBox3.Text;
            email.Subject = textBox2.Text;

            if (czyJestZalacznik)
            {
                email.Attachments.Add(new Attachment(sciezkaZalacznika));
            }

            try
            {                
                DialogResult wynik = MessageBox.Show("List zostanie umieszczony w skrzynce nadawczej. Czy zsynchronizować skrzynce?", "", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button3);
                switch (wynik)
                {
                    case DialogResult.Cancel: 
                        break;
                    case DialogResult.No:
                        wybraneKonto.Send(email);
                        Close();
                        break;
                    case DialogResult.Yes:
                        wybraneKonto.Send(email);
                        MessagingApplication.Synchronize(wybraneKonto);
                        Close();
                        break;
                }                
            }
            catch(Exception exc)
            {
                MessageBox.Show("Nie udało się wysłanie wiadomości (" + exc.Message + ")");
            }
        }

        private void menuItem3_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}