﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.WindowsMobile.Status;

namespace DetekcjaStanuUrzadzenia
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            listBox1.DataSource = pobierzInformacjeOStanieUrzadzenia();
        }

        string[] pobierzInformacjeOStanieUrzadzenia()
        {
            List<string> lista = new List<string>();
            //konieczne podlaczenie Microsoft.WindowsMobile (choć jawnie nie wykorzytywane)
            lista.Add("Stan urządzenia (" + SystemState.Time.ToString() + ")");

            lista.Add("Właściciel: " + SystemState.OwnerName);
            lista.Add("");

            lista.Add("Orientacja urządzenia: " + SystemState.DisplayRotation.ToString());
            lista.Add("Urządzenie zablokowane: " + SystemState.DeviceLocked.ToString());
            lista.Add("");

            lista.Add("Ilość nieprzeczytanych wiadomości SMS: " + SystemState.MessagingSmsUnread.ToString());
            lista.Add("Ilość nieprzeczytanych e-maili: " + SystemState.MessagingTotalEmailUnread.ToString());
            lista.Add("");

            lista.Add("Karta WiFi: " + SystemState.WiFiStateHardwarePresent);
            lista.Add("WiFi włączane: " + SystemState.WiFiStatePowerOn);
            lista.Add("WiFi połączone: " + SystemState.WiFiStateConnected);
            lista.Add("");

            lista.Add("Nazwa operatora sieci komórkowej: " + SystemState.PhoneOperatorName);
            lista.Add("");

            lista.Add("Aparat fotograficzny: " + SystemState.CameraPresent);
            lista.Add("Aparat zablokowany: " + !SystemState.CameraEnabled);

            lista.Add("Stan baterii: " + SystemState.PowerBatteryState.ToString());
            lista.Add("Poziom naładowania: " + SystemState.PowerBatteryStrength.ToString());

            return lista.ToArray<string>();
        }

        private void menuItem1_Click(object sender, EventArgs e)
        {
            //listBox1.Items.Clear();
            listBox1.DataSource = pobierzInformacjeOStanieUrzadzenia();
        }
    }
}