package pl.umk.fizyka.wibracje;

import android.content.Context;
import android.os.Parcel;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.SeekBar;

public class MainActivity extends AppCompatActivity
{
    SeekBar suwak;
    Button przycisk1, przycisk2;
    Vibrator wibrator;

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        wibrator = (Vibrator)getSystemService(Context.VIBRATOR_SERVICE);

        suwak = findViewById(R.id.seekBar);
        przycisk1 = findViewById(R.id.button1);
        przycisk2 = findViewById(R.id.button2);
        przycisk2 = findViewById(R.id.button3);
        przycisk1.setOnClickListener(
                new View.OnClickListener()
                {
                    @Override
                    public void onClick(View view)
                    {
                        if(wibrator.hasVibrator())
                        {
                            int czas = suwak.getProgress();
                            wibrator.vibrate(czas); //obsolete
                        }
                    }
                }
        );
        przycisk2.setOnClickListener(
                new View.OnClickListener()
                {
                    @Override
                    public void onClick(View view)
                    {
                        if(wibrator.hasVibrator())
                        {
                            wibrator.cancel();
                        }
                    }
                }
        );
        przycisk1.setOnClickListener(
                new View.OnClickListener()
                {
                    @Override
                    public void onClick(View view)
                    {
                        if(wibrator.hasVibrator())
                        {
                            int czas = suwak.getProgress();
                            VibrationEffect ve = VibrationEffect.createOneShot(czas, VibrationEffect.DEFAULT_AMPLITUDE);
                            wibrator.vibrate(ve);
                        }
                    }
                }
        );
    }
}
