package pl.umk.fizyka.style_piersien;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        Thread t = new Thread()
        {
            public void pokazToast(final String komunikat)
            {
                runOnUiThread(
                        new Runnable()
                        {
                            @Override
                            public void run()
                            {
                                Toast.makeText(MainActivity.this, komunikat, Toast.LENGTH_SHORT).show();
                            }
                        }
                );
            }

            @Override
            public void run()
            {
                //super.run();

                try
                {
                    Thread.sleep(5000);
                    pokazToast("inicjacja zakończona");
                }
                catch (InterruptedException exc)
                {
                    //inicjacja przerwana
                }
                finally
                {
                    runOnUiThread(
                            new Runnable()
                            {
                                @Override
                                public void run()
                                {
                                    View panelPierscienia = findViewById(R.id.panelPierscienia);
                                    panelPierscienia.setVisibility(View.GONE);
                                }
                            }
                    );
                    //inicjacja zakończona
                }
            }
        };
        t.start();
    }
}
