package pl.umk.fizyka.stanurzadzenia;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityManager.MemoryInfo;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.media.AudioManager;
import android.os.BatteryManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.StatFs;
import android.util.FloatMath;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

//uwaga: emulator powinien miec wsparcie baterii (Battery Support: yes)

public class StanActivity extends Activity {
    ListView listView;
    BroadcastReceiver batteryReceiver;

    Handler handler = new Handler() {
        public void handleMessage(Message message) {
            odswiezListe();
        }
    };

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_stan);

        TextView naglowek = (TextView) findViewById(R.id.naglowek);
        naglowek.setText(naglowek.getText() + "\n" + Build.MANUFACTURER + " " + Build.MODEL + " (" + Build.PRODUCT + ")");

        listView = (ListView) findViewById(R.id.listView);
        odswiezListe();

        final int coIleMilisekundOswiezacListe = 2000; //2s
        Thread timer = new Thread() {
            public void run() {
                while (true) {
                    //w osobnym watku
                    handler.sendEmptyMessage(0);
                    try {
                        Thread.sleep(coIleMilisekundOswiezacListe);
                    } catch (InterruptedException e) {
                    }
                }
            }
        };
        timer.start();
    }

    private void odswiezListe() {
        int pozycja = listView.getFirstVisiblePosition();
        View v = listView.getChildAt(0);
        int top = (v == null) ? 0 : v.getTop();

        ArrayList<UrzadzenieInfo> listaUrzadzen = new ArrayList<UrzadzenieInfo>();
        //tu dodawaj opisy stanu kolejnych urzadzen
        listaUrzadzen.add(odczytajWersjęSystemu(this));
        listaUrzadzen.add(odczytajStanPamięci(this));
        listaUrzadzen.add(odczytajStanGłównejKartyPamięci(this));
        listaUrzadzen.add(odczytajStanDodatkowejKartyPamięci(this));

        if (batteryReceiver == null)
            batteryReceiver = new BroadcastReceiver() {
                @Override
                public void onReceive(Context context, Intent intent) {
                    int bateriaPoziom = intent.getIntExtra(BatteryManager.EXTRA_LEVEL, -1);
                    if (bateriaPoziom < 10)
                        Toast.makeText(getApplicationContext(), "Niski poziom baterii", Toast.LENGTH_SHORT).show();
                }
            };
        IntentFilter intentFilter = new IntentFilter(Intent.ACTION_BATTERY_CHANGED);
        Intent intent = this.getApplicationContext().registerReceiver(batteryReceiver, intentFilter);
        listaUrzadzen.add(odczytajStanBaterii(this, intent));

        listaUrzadzen.add(odczytajObecnośćDodatkowychUrządzeń(this));
        listaUrzadzen.add(odczytajStanAudio(this));
        listaUrzadzen.add(odczytajObecnośćCzujników(this));

        UrzadzeniaAdapter a = new UrzadzeniaAdapter(this, R.layout.wiersz, listaUrzadzen);
        listView.setAdapter(a);

        listView.setSelectionFromTop(pozycja, top);
    }

    static public enum TypInformacji {StanUrzadzenia, Czujnik, Inne}

    ;

    static int kolorDlaTypuInformacji(TypInformacji typInformacji) {
        int kolor = Color.WHITE;
        switch (typInformacji) {
            case StanUrzadzenia:
                kolor = Color.YELLOW;
                break;
            case Czujnik:
                kolor = Color.GREEN;
                break;
            default:
            case Inne:
                kolor = Color.WHITE;
                break;
        }
        return kolor;
    }

    static private class UrzadzenieInfo {
        public TypInformacji typInformacji;
        public String nazwa;
        public int polozeniePaska;
        public String opis;
    }

    //tu umiesc metody odczytujace stan urzadzen

    public static synchronized int readRAMTotalSizeKB() {
        try {
            RandomAccessFile reader = new RandomAccessFile("/proc/meminfo", "r");
            String s = reader.readLine();
            reader.close();
            String[] totrm = s.split(" kB", 0);
            String[] trm = totrm[0].split(" ");
            int tm = 0;
            tm = Integer.parseInt(trm[trm.length - 1]);
            return tm;
        } catch (IOException ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    //http://stackoverflow.com/questions/3118234/how-to-get-memory-usage-and-cpu-usage-in-android
    private static float readCPUUsage() {
        try {
            RandomAccessFile reader = new RandomAccessFile("/proc/stat", "r");
            String load = reader.readLine();

            String[] toks = load.split(" ");

            long idle1 = Long.parseLong(toks[5]);
            long cpu1 = Long.parseLong(toks[2]) + Long.parseLong(toks[3]) + Long.parseLong(toks[4])
                    + Long.parseLong(toks[6]) + Long.parseLong(toks[7]) + Long.parseLong(toks[8]);

            try {
                Thread.sleep(360);
            } catch (Exception e) {
            }

            reader.seek(0);
            load = reader.readLine();
            reader.close();

            toks = load.split(" ");

            long idle2 = Long.parseLong(toks[5]);
            long cpu2 = Long.parseLong(toks[2]) + Long.parseLong(toks[3]) + Long.parseLong(toks[4])
                    + Long.parseLong(toks[6]) + Long.parseLong(toks[7]) + Long.parseLong(toks[8]);

            return (float) (cpu2 - cpu1) / ((cpu2 + idle2) - (cpu1 + idle1));

        } catch (IOException ex) {
            ex.printStackTrace();
        }

        return 0;
    }

    //http://www.roman10.net/how-to-get-cpu-information-on-android/
    private static String readCPUInfo() {
        StringBuffer sb = new StringBuffer();
        //sb.append("abi: ").append(Build.CPU_ABI).append("\n");
        if (new File("/proc/cpuinfo").exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(new File("/proc/cpuinfo")));
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
                if (br != null) {
                    br.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.activity_stan, menu);
        return true;
    }

    //dodane
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        super.onOptionsItemSelected(item);

        switch (item.getItemId()) {
            case R.id.menu_odswiez:
                odswiezListe();
                break;
            case R.id.menu_koniec:
                this.finish();
                break;
            case R.id.menu_menedzer_zadan:
                Intent launchIntent = getPackageManager().getLaunchIntentForPackage("pl.umk.menedzerzadan");
                startActivity(launchIntent);
                //overridePendingTransition(0, 0);
                break;
            case R.id.menu_info:
                Toast.makeText(getApplicationContext(), R.string.info, Toast.LENGTH_LONG).show();
                break;
        }
        return true;
    }

    private class UrzadzeniaAdapter extends ArrayAdapter<UrzadzenieInfo> {
        private ArrayList<UrzadzenieInfo> items;

        public UrzadzeniaAdapter(Context context, int textViewResourceId, ArrayList<UrzadzenieInfo> items) {
            super(context, textViewResourceId, items);
            this.items = items;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            View v = convertView;
            if (v == null) {
                LayoutInflater vi = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                v = vi.inflate(R.layout.wiersz, null);
            }
            UrzadzenieInfo o = items.get(position);
            if (o != null) {
                TextView nazwa = (TextView) v.findViewById(R.id.nazwa);
                if (nazwa != null) nazwa.setText(o.nazwa);
                nazwa.setTextColor(kolorDlaTypuInformacji(o.typInformacji));

                ProgressBar pasek = (ProgressBar) v.findViewById(R.id.pasek);
                pasek.setProgress((o.polozeniePaska == -1) ? 0 : o.polozeniePaska);

                TextView opis = (TextView) v.findViewById(R.id.opis);
                if (opis != null) opis.setText(o.opis);
            }
            return v;
        }
    }

    @Override
    protected void onResume() {
        super.onResume();

        //Toast.makeText(getApplicationContext(), "Rozpoczynam odczyty czujników", Toast.LENGTH_LONG).show();
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (batteryReceiver != null)
            this.getApplicationContext().unregisterReceiver(batteryReceiver);
    }

    static private UrzadzenieInfo odczytajWersjęSystemu(Activity activity) {
        UrzadzenieInfo systemInfo = new UrzadzenieInfo();
        systemInfo.nazwa = "Wersja systemu";
        systemInfo.typInformacji = TypInformacji.Inne;
        systemInfo.polozeniePaska = -1;
        systemInfo.opis = "\nBieżąca data i czas: " + new Date().toLocaleString(); //deprecated
        systemInfo.opis += "\nBieżąca data: " + DateFormat.getDateInstance().format(new Date());
        systemInfo.opis += "\nBieżący czas: " + DateFormat.getTimeInstance().format(new Date());
        systemInfo.opis += "\nProducent: " + Build.MANUFACTURER;
        systemInfo.opis += "\nUrządzenia: " + Build.DEVICE;
        systemInfo.opis += "\nWersja: " + Build.VERSION.RELEASE +
                " (" + Build.VERSION.INCREMENTAL + ")";
        systemInfo.opis += "\nTyp CPU: " + Build.CPU_ABI; //deprecated
        systemInfo.opis += "\nTyp CPU: ";
        for (String abi : Build.SUPPORTED_ABIS) //API 21
        {
            systemInfo.opis += "\n\t" + abi;
        }
        systemInfo.opis += "\nWyświetlacz: " + Build.DISPLAY;
        return systemInfo;
    }

    static private UrzadzenieInfo odczytajStanPamięci(Activity activity) {
        //Pamięć wewnętrzna
        UrzadzenieInfo pi = new UrzadzenieInfo();
        pi.typInformacji = TypInformacji.StanUrzadzenia;
        pi.nazwa = "Pamięć (RAM)";

        ActivityManager am = (ActivityManager) activity.getSystemService(ACTIVITY_SERVICE);
        MemoryInfo mi = new MemoryInfo();
        am.getMemoryInfo(mi);
        long pamięćDostępną = mi.availMem / 1024; //kB
        //mi.totalMem
        long pamięćCałkowita = readRAMTotalSizeKB();
        long pamięćZajęta = pamięćCałkowita - pamięćDostępną;
        pi.opis = "Dostępna pamięć: " + pamięćDostępną + "/" + pamięćCałkowita;
        pi.polozeniePaska = (int) (pamięćZajęta * 100 / pamięćCałkowita);
        return pi;
    }


    static private Pair<String, Integer> pobierzStanPamięci(File memoryDirectory) {
        StatFs systemPlików = new StatFs(memoryDirectory.getPath());
        long wolneMiejsce =
                systemPlików.getAvailableBlocksLong() *
                        systemPlików.getBlockSizeLong()
                        / 1024 / 1024; //MB
        long rozmiar =
                systemPlików.getBlockCountLong() *
                        systemPlików.getBlockSizeLong()
                        / 1024 / 1024; //MB
        long zajęteMiejsce = rozmiar - wolneMiejsce;

        String opis = "Ścieżka: " + memoryDirectory.getPath() + "\n";
        opis += "Wolne miejsce: " + wolneMiejsce + " / " + rozmiar;
        int procent = (int) (zajęteMiejsce * 100 / rozmiar);

        Pair<String, Integer> tuple = new Pair<String, Integer>(opis, new Integer(procent));
        return tuple;
    }

    static private UrzadzenieInfo odczytajStanGłównejKartyPamięci(Activity activity) {
        Pair<String, Integer> tuple = pobierzStanPamięci(Environment.getRootDirectory());

        UrzadzenieInfo kartaPamięciInfo = new UrzadzenieInfo();
        kartaPamięciInfo.typInformacji = TypInformacji.StanUrzadzenia;
        kartaPamięciInfo.nazwa = "Głowna karta pamięci";
        kartaPamięciInfo.opis = tuple.first;
        kartaPamięciInfo.polozeniePaska = tuple.second;
        return kartaPamięciInfo;
    }

    static private UrzadzenieInfo odczytajStanDodatkowejKartyPamięci(Activity activity) {
        UrzadzenieInfo kartaPamięciInfo = new UrzadzenieInfo();
        kartaPamięciInfo.typInformacji = TypInformacji.StanUrzadzenia;
        kartaPamięciInfo.nazwa = "Dodatkowa karta pamięci";

        if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
            Pair<String, Integer> tuple = pobierzStanPamięci(Environment.getExternalStorageDirectory());
            kartaPamięciInfo.opis = tuple.first;
            kartaPamięciInfo.polozeniePaska = tuple.second;
        } else {
            kartaPamięciInfo.opis = "Brak";
            kartaPamięciInfo.polozeniePaska = -1;
        }
        return kartaPamięciInfo;
    }

    static private UrzadzenieInfo odczytajStanBaterii(Activity activity, Intent intent) {
        //API 5
        UrzadzenieInfo bi = new UrzadzenieInfo();
        bi.typInformacji = TypInformacji.StanUrzadzenia;
        bi.nazwa = "Bateria";

        if (intent.getBooleanExtra(BatteryManager.EXTRA_PRESENT, false)) {
            String technologia = intent.getStringExtra(BatteryManager.EXTRA_TECHNOLOGY);
            int bateriaStan = intent.getIntExtra(BatteryManager.EXTRA_STATUS, -1);
            String stanOpis = "";
            switch (bateriaStan) {
                case BatteryManager.BATTERY_STATUS_CHARGING:
                    stanOpis = "ładowanie";
                    break;
                case BatteryManager.BATTERY_STATUS_DISCHARGING:
                    stanOpis = "rozładowywanie";
                    break;
                case BatteryManager.BATTERY_STATUS_FULL:
                    stanOpis = "w pełni naładowana";
                    break;
                case BatteryManager.BATTERY_STATUS_NOT_CHARGING:
                    stanOpis = "nie ładowanie";
                    break;
                default:
                case BatteryManager.BATTERY_STATUS_UNKNOWN:
                    stanOpis = "nieznany";
                    break;
            }

            int metodaŁadowania = intent.getIntExtra(BatteryManager.EXTRA_PLUGGED, -1);
            String ładowanieOpis = "";
            switch (metodaŁadowania) {
                case BatteryManager.BATTERY_PLUGGED_AC:
                    ładowanieOpis = "AC";
                    break;
                case BatteryManager.BATTERY_PLUGGED_USB:
                    ładowanieOpis = "USB";
                    break;
                default:
                    ładowanieOpis = "nieznane";
                    break;
            }

            int skala = intent.getIntExtra(BatteryManager.EXTRA_SCALE, -1);
            int poziom = intent.getIntExtra(BatteryManager.EXTRA_LEVEL, -1);
            int napięcie = intent.getIntExtra(BatteryManager.EXTRA_VOLTAGE, -1);
            int temperatura = intent.getIntExtra(BatteryManager.EXTRA_TEMPERATURE, -1);

            bi.opis = "Technologia: " + technologia;
            bi.opis += "\nStan: " + stanOpis;
            bi.opis += "\nŁadowanie: " + ładowanieOpis;
            bi.opis += "\nPoziom naładowania: " + poziom + " / " + skala;
            bi.opis += "\nNapięcie: " + napięcie + "mV";
            bi.opis += "\nTemperatura: " + temperatura / 10 + " st. C";
            bi.polozeniePaska = poziom * 100 / skala;
        } else {
            bi.opis = "Brak baterii";
            bi.polozeniePaska = -1;
        }
        return bi;
    }

    static private UrzadzenieInfo odczytajObecnośćDodatkowychUrządzeń(Activity activity) {
        UrzadzenieInfo dui = new UrzadzenieInfo();
        dui.typInformacji = TypInformacji.Inne;
        dui.nazwa = "Dodatkowe urządzenia";
        dui.polozeniePaska = -1;

        PackageManager pm = activity.getPackageManager();

        //telefon
        boolean czyTelefonObecny = pm.hasSystemFeature(PackageManager.FEATURE_TELEPHONY);
        dui.opis = "Telefon obecny " + (czyTelefonObecny ? "obecny" : "brak");
        if (czyTelefonObecny) {
            dui.opis += pm.hasSystemFeature(PackageManager.FEATURE_TELEPHONY_GSM) ? "(GSM)" : "";
            dui.opis += pm.hasSystemFeature(PackageManager.FEATURE_TELEPHONY_CDMA) ? "(CDMA)" : "";
        }

        //aparat i kamera
        boolean czyKameraObecna = pm.hasSystemFeature(PackageManager.FEATURE_CAMERA);
        dui.opis = "Aparat obecny " + (czyKameraObecna ? "obecny" : "brak");
        if (czyKameraObecna) {
            dui.opis += "\n\tautomatyczna regulacja ostrości: " + (pm.hasSystemFeature(PackageManager.FEATURE_CAMERA_AUTOFOCUS) ? "obecna" : "brak");
            dui.opis += "\n\tlampa błyskowa: " + (pm.hasSystemFeature(PackageManager.FEATURE_CAMERA_FLASH) ? "obecna" : "brak");
        }

        dui.opis += "\nCzujnik oświetlenia: " + (pm.hasSystemFeature(PackageManager.FEATURE_SENSOR_LIGHT) ? "obecny" : "brak");
        dui.opis += "\nCzujnik zbliżeniowy: " + (pm.hasSystemFeature(PackageManager.FEATURE_SENSOR_PROXIMITY) ? "obecny" : "brak");
        dui.opis += "\nWielodotyk: " + (pm.hasSystemFeature(PackageManager.FEATURE_TOUCHSCREEN_MULTITOUCH) ? "obecny" : "brak");
        dui.opis += "\nAnimowana tapeta: " + (pm.hasSystemFeature(PackageManager.FEATURE_LIVE_WALLPAPER) ? "obecna" : "brak");

        return dui;
    }

    static private UrzadzenieInfo odczytajStanAudio(Activity activity) {
        UrzadzenieInfo ai = new UrzadzenieInfo();
        ai.typInformacji = TypInformacji.Inne;
        ai.nazwa = "Audio";
        ai.polozeniePaska = -1;

        AudioManager am = (AudioManager) activity.getSystemService(Context.AUDIO_SERVICE);

        int trybAudio = am.getMode();
        String trybAudioOpis = "Tryb audio: ";
        switch (trybAudio) {
            case AudioManager.MODE_NORMAL:
                trybAudioOpis += "normalny";
                break;
            case AudioManager.MODE_RINGTONE:
                trybAudioOpis += "dzwonki";
                break;
            case AudioManager.MODE_IN_CALL:
                trybAudioOpis += "w trakcie rozmowy";
                break;
            case AudioManager.MODE_INVALID:
                trybAudioOpis += "niepoprawny";
                break;
            default:
                trybAudioOpis += "nierozpoznany";
                break;
        }
        ai.opis = trybAudioOpis;

        int trybDzwonka = am.getRingerMode();
        String trybDzwonkaOpis = "\nTryb dzwonka: ";
        switch (trybDzwonka) {
            case AudioManager.RINGER_MODE_NORMAL:
                trybDzwonkaOpis += "normalny";
                break;
            case AudioManager.RINGER_MODE_SILENT:
                trybDzwonkaOpis += "wyciszony";
                break;
            case AudioManager.RINGER_MODE_VIBRATE:
                trybDzwonkaOpis += "wibracje";
                break;
            default:
                trybDzwonkaOpis += "nierozpoznany";
                break;
        }
        ai.opis += trybDzwonkaOpis;

        ai.opis += "\nWyciszenie mikrofonu: " + (am.isMicrophoneMute() ? "tak" : "nie");
        ai.opis += "\nOdtwarzanie muzyki: " + (am.isMusicActive() ? "tak" : "nie");

        return ai;
    }

    static private String opisCzujnika(List<Sensor> lista, String nazwa)
    {
        String opis = nazwa + ": ";
        if(lista.size()>1) opis += "\n";
        if(lista.size()>0)
        {
            for(int i = 0; i < lista.size(); ++i)
            {
                if(lista.size()>1) opis += "\t";
                Sensor czujnik = lista.get(i);
                opis+=czujnik.getName()+", wersja: " + czujnik.getVersion() + "\n";
            }
        }
        else opis += "brak\n";
        return opis;
    }

    static private UrzadzenieInfo odczytajObecnośćCzujników(Activity activity)
    {
        UrzadzenieInfo si = new UrzadzenieInfo();
        si.typInformacji = TypInformacji.Inne;
        si.nazwa = "Czujniki";
        si.polozeniePaska = -1;

        SensorManager sm = (SensorManager)activity.getSystemService(Context.SENSOR_SERVICE);
        si.opis += opisCzujnika(sm.getSensorList(Sensor.TYPE_ACCELEROMETER), "akcelerometr");
        si.opis += opisCzujnika(sm.getSensorList(Sensor.TYPE_GYROSCOPE), "żyroskop");
        si.opis += opisCzujnika(sm.getSensorList(Sensor.TYPE_ORIENTATION), "orientacja");
        si.opis += opisCzujnika(sm.getSensorList(Sensor.TYPE_LIGHT), "oświetlenie");
        si.opis += opisCzujnika(sm.getSensorList(Sensor.TYPE_MAGNETIC_FIELD), "pole magnetyczne");
        si.opis += opisCzujnika(sm.getSensorList(Sensor.TYPE_PRESSURE), "ciśnienie");
        si.opis += opisCzujnika(sm.getSensorList(Sensor.TYPE_PROXIMITY), "zbliżeniowy");
        si.opis += opisCzujnika(sm.getSensorList(Sensor.TYPE_AMBIENT_TEMPERATURE), "temperatura otoczenia");

        return si;
    }
}
