package pl.umk.fizyka.ulamekdemo;

import android.support.annotation.NonNull;

public class Para<T extends Comparable<T>> implements Comparable<Para<T>>
{
    private T pierwszy;
    private T drugi;

    public Para(T pierwszy, T drugi)
    {
        this.pierwszy = pierwszy;
        this.drugi = drugi;
    }

    @Override
    public String toString()
    {
        return pierwszy.toString() + "\t" + drugi.toString();
    }

    @Override
    public int compareTo(@NonNull Para<T> innaPara)
    {
        int wartość = this.pierwszy.compareTo(innaPara.pierwszy);
        if(wartość != 0) return (int)Math.signum(wartość);
        else return this.drugi.compareTo(innaPara.drugi);
    }
}
