package pl.umk.fizyka.kolory;

import android.graphics.Color;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.widget.SeekBar;
import android.widget.TextView;

public class MainActivity extends AppCompatActivity
{
    private SeekBar seekBarR, seekBarG, seekBarB;
    private TextView etykieta_panel;

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        etykieta_panel = (TextView)findViewById(R.id.etykieta_panel);
        seekBarR = (SeekBar) findViewById(R.id.seekBarR);
        seekBarG = (SeekBar) findViewById(R.id.seekBarG);
        seekBarB = (SeekBar) findViewById(R.id.seekBarB);

        seekBarR.setOnSeekBarChangeListener(seekBarChangeListener);
        seekBarG.setOnSeekBarChangeListener(seekBarChangeListener);
        seekBarB.setOnSeekBarChangeListener(seekBarChangeListener);

        //seekBarR.setProgress(0);
        //seekBarG.setProgress(0);
        //seekBarB.setProgress(0);

        seekBarChangeListener.onProgressChanged(null, 0, true);
    }

    private SeekBar.OnSeekBarChangeListener seekBarChangeListener = new SeekBar.OnSeekBarChangeListener()
    {
        private String toHexString2(int value)
        {
            String s = Integer.toHexString(value).toUpperCase();
            if(s.length() == 1) s = "0" + s;
            return s;
        }

        @Override
        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser)
        {
            int r = seekBarR.getProgress();
            int g = seekBarG.getProgress();
            int b = seekBarB.getProgress();

            String sr = toHexString2(r);
            String sg = toHexString2(g);
            String sb = toHexString2(b);

            etykieta_panel.setBackgroundColor(Color.rgb(r,g,b));
            etykieta_panel.setText("Składowe koloru: #" + sr + sg + sb);
        }

        @Override
        public void onStartTrackingTouch(SeekBar seekBar)
        {
        }

        @Override
        public void onStopTrackingTouch(SeekBar seekBar)
        {
        }
    };
}
