package pl.umk.fizyka.stanurzadzenia;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityManager.MemoryInfo;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.media.AudioManager;
import android.os.BatteryManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.StatFs;
import android.util.FloatMath;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

//uwaga: emulator powinien miec wsparcie baterii (Battery Support: yes)

public class StanActivity extends Activity
{
	ListView listView;

	Handler handler = new Handler ()
    {
        public void handleMessage (Message message)
        {
            odswiezListe();
        }
    };

    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_stan);

        TextView naglowek = (TextView)findViewById(R.id.naglowek);
        naglowek.setText(naglowek.getText()+"\n"+Build.MANUFACTURER+" "+Build.MODEL+" ("+Build.PRODUCT+")");

        listView = (ListView)findViewById(R.id.listView);
        odswiezListe();

        final int coIleMilisekundOswiezacListe = 2000; //2s
        Thread timer = new Thread()
        {
            public void run ()
            {
                while(true)
                {
                	//w osobnym watku
                    handler.sendEmptyMessage(0);
                    try
                    {
						Thread.sleep(coIleMilisekundOswiezacListe);
					}
                    catch (InterruptedException e)
                    {
					}
                }
            }
        };
        timer.start();
    }

    private void odswiezListe()
    {
    	int pozycja = listView.getFirstVisiblePosition();
    	View v = listView.getChildAt(0);
    	int top = (v==null)?0:v.getTop();

        ArrayList<UrzadzenieInfo> listaUrzadzen = new ArrayList<UrzadzenieInfo>();
        //tu dodawaj opisy stanu kolejnych urzadzen

        UrzadzeniaAdapter a=new UrzadzeniaAdapter(this,R.layout.wiersz,listaUrzadzen);
        listView.setAdapter(a);

        listView.setSelectionFromTop(pozycja, top);
    }

    static public enum TypInformacji { StanUrzadzenia,Czujnik,Inne };

    static int kolorDlaTypuInformacji(TypInformacji typInformacji)
	{
		int kolor = Color.WHITE;
		switch(typInformacji)
		{
		case StanUrzadzenia:
			kolor = Color.YELLOW;
			break;
		case Czujnik:
			kolor = Color.GREEN;
			break;
		default:
		case Inne:
			kolor = Color.WHITE;
			break;
		}
		return kolor;
	}

    static private class UrzadzenieInfo
    {
    	public TypInformacji typInformacji;
    	public String nazwa;
    	public int polozeniePaska;
    	public String opis;
    }

    //tu umiesc metody odczytujace stan urzadzen

	public static synchronized int readRAMTotalSizeKB()
	{
		try
		{
			RandomAccessFile reader = new RandomAccessFile("/proc/meminfo", "r");
			String s = reader.readLine();
			reader.close();
			String[] totrm = s.split(" kB",0);
			String[] trm = totrm[0].split(" ");
			int tm = 0;
			tm = Integer.parseInt(trm[trm.length - 1]);
			return tm;
		}
		catch (IOException ex)
		{
			ex.printStackTrace();
			return -1;
		}
	}

    //http://stackoverflow.com/questions/3118234/how-to-get-memory-usage-and-cpu-usage-in-android
    private static float readCPUUsage()
    {
        try
        {
            RandomAccessFile reader = new RandomAccessFile("/proc/stat", "r");
            String load = reader.readLine();

            String[] toks = load.split(" ");

            long idle1 = Long.parseLong(toks[5]);
            long cpu1 = Long.parseLong(toks[2]) + Long.parseLong(toks[3]) + Long.parseLong(toks[4])
                  + Long.parseLong(toks[6]) + Long.parseLong(toks[7]) + Long.parseLong(toks[8]);

            try
            {
                Thread.sleep(360);
            }
            catch (Exception e) {}

            reader.seek(0);
            load = reader.readLine();
            reader.close();

            toks = load.split(" ");

            long idle2 = Long.parseLong(toks[5]);
            long cpu2 = Long.parseLong(toks[2]) + Long.parseLong(toks[3]) + Long.parseLong(toks[4])
                + Long.parseLong(toks[6]) + Long.parseLong(toks[7]) + Long.parseLong(toks[8]);

            return (float)(cpu2 - cpu1) / ((cpu2 + idle2) - (cpu1 + idle1));

        }
        catch (IOException ex)
        {
            ex.printStackTrace();
        }

        return 0;
    }

    //http://www.roman10.net/how-to-get-cpu-information-on-android/
    private static String readCPUInfo()
    {
        StringBuffer sb = new StringBuffer();
        //sb.append("abi: ").append(Build.CPU_ABI).append("\n");
        if (new File("/proc/cpuinfo").exists())
        {
            try
            {
                BufferedReader br = new BufferedReader(new FileReader(new File("/proc/cpuinfo")));
                String line;
                while ((line = br.readLine()) != null)
                {
                	sb.append(line + "\n");
                }
                if (br != null)
                {
                    br.close();
                }
            }
            catch (IOException e)
            {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu)
    {
        getMenuInflater().inflate(R.menu.activity_stan, menu);
        return true;
    }

    //dodane
    @Override
	public boolean onOptionsItemSelected(MenuItem item) {
		super.onOptionsItemSelected(item);

		switch(item.getItemId())
		{
		case R.id.menu_odswiez:
			odswiezListe();
			break;
		case R.id.menu_koniec:
			this.finish();
			break;
		case R.id.menu_menedzer_zadan:
			Intent launchIntent = getPackageManager().getLaunchIntentForPackage("pl.umk.menedzerzadan");
			startActivity(launchIntent);
			//overridePendingTransition(0, 0);
			break;
		case R.id.menu_info:
			Toast.makeText(getApplicationContext(), R.string.info, Toast.LENGTH_LONG).show();
			break;
		}
		return true;
	}

    private class UrzadzeniaAdapter extends ArrayAdapter<UrzadzenieInfo>
	{
        private ArrayList<UrzadzenieInfo> items;

        public UrzadzeniaAdapter(Context context, int textViewResourceId, ArrayList<UrzadzenieInfo> items)
        {
        	super(context, textViewResourceId, items);
            this.items = items;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent)
        {
        	View v = convertView;
            if (v == null)
            {
            	LayoutInflater vi = (LayoutInflater)getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                v = vi.inflate(R.layout.wiersz, null);
            }
            UrzadzenieInfo o = items.get(position);
            if (o != null)
            {
            	TextView nazwa = (TextView)v.findViewById(R.id.nazwa);
            	if (nazwa != null) nazwa.setText(o.nazwa);
            	nazwa.setTextColor(kolorDlaTypuInformacji(o.typInformacji));

            	ProgressBar pasek = (ProgressBar)v.findViewById(R.id.pasek);
            	pasek.setProgress((o.polozeniePaska==-1)?0:o.polozeniePaska);

            	TextView opis = (TextView)v.findViewById(R.id.opis);
                if(opis != null) opis.setText(o.opis);
            }
            return v;
        }
	}

    @Override
    protected void onResume()
    {
    	super.onResume();

    	//Toast.makeText(getApplicationContext(), "Rozpoczynam odczyty czujników", Toast.LENGTH_LONG).show();
	}
    
    @Override
    protected void onPause() 
    {    	
    	super.onPause();
  	
    }
}
