﻿using ReversiSilnik;
using System.Collections.ObjectModel;

namespace Reversi2026;

public partial class MainPage : ContentPage
{
    private ReversiSilnikAI silnik = new ReversiSilnikAI(1, 8, 8);

    private Color[] kolory = { Colors.Ivory, Colors.Green, Colors.Sienna };
    private string[] nazwyGraczy = { "", "zielony", "brązowy" };

    private Button[,] plansza;

    private bool graPrzeciwkoKomputerowi = true;

    private bool planszaZainicjowana
    {
        get
        {
            return plansza[silnik.SzerokośćPlanszy - 1, silnik.WysokośćPlanszy - 1] != null;
        }
    }

    private void uzgodnijZawartośćPlanszy()
    {
        if (!planszaZainicjowana) return;

        for (int poziomo = 0; poziomo < silnik.SzerokośćPlanszy; poziomo++)
            for (int pionowo = 0; pionowo < silnik.WysokośćPlanszy; pionowo++)
            {
                WspółrzędnePola współrzędnePola = new WspółrzędnePola(poziomo, pionowo);
                plansza[poziomo, pionowo].BackgroundColor = kolory[silnik.PobierzStanPola(współrzędnePola)];
                /*
                if (silnik.PobierzStanPola(współrzędnePola) == 0 && !silnik.CzyMożnaPołożyćKamień(współrzędnePola))
                {
                    plansza[poziomo, pionowo].BackgroundColor = Colors.LightGray;
                    plansza[poziomo, pionowo].IsEnabled = false;
                }
                if (silnik.PobierzStanPola(współrzędnePola) == 0 && !silnik.CzyMożnaPołożyćKamień(współrzędnePola))
                {
                    plansza[poziomo, pionowo].IsEnabled = true;
                }
                */
                //plansza[poziomo, pionowo].IsEnabled = silnik.CzyMożnaPołożyćKamień(współrzędnePola);
                //plansza[poziomo, pionowo].Text = silnik.PobierzStanPola(współrzędnePola).ToString();
                plansza[poziomo, pionowo].TextColor = plansza[poziomo, pionowo].BackgroundColor.GetLuminosity() > 0.5 ? Colors.Black : Colors.White;
                //plansza[poziomo, pionowo].Text = silnik.CzyMożnaPołożyćKamień(współrzędnePola).ToString();
                //plansza[poziomo, pionowo].IsEnabled = false;
            }

        btnKolorGracza.BackgroundColor = kolory[silnik.NumerGraczaWykonującegoNastępnyRuch];
        Shell.SetBackgroundColor(this, btnKolorGracza.BackgroundColor);
        lbLiczbaPólZielony.Text = silnik.LiczbaPólGracz1.ToString();
        lbLiczbaPólBrązowy.Text = silnik.LiczbaPólGracz2.ToString();
    }

    public MainPage()
    {
        InitializeComponent();

        //podział siatki na wiersze i kolumny
        for (int poziomo = 0; poziomo < silnik.SzerokośćPlanszy; poziomo++)
            grPlansza.ColumnDefinitions.Add(new ColumnDefinition());
        for (int pionowo = 0; pionowo < silnik.WysokośćPlanszy; pionowo++)
            grPlansza.RowDefinitions.Add(new RowDefinition());

        //tworzenie przycisków
        plansza = new Button[silnik.SzerokośćPlanszy, silnik.WysokośćPlanszy];
        for (int poziomo = 0; poziomo < silnik.SzerokośćPlanszy; poziomo++)
            for (int pionowo = 0; pionowo < silnik.WysokośćPlanszy; pionowo++)
            {
                Button przycisk = new Button();
                przycisk.Margin = new Thickness(0);
                grPlansza.Children.Add(przycisk);
                Grid.SetColumn(przycisk, pionowo);
                Grid.SetRow(przycisk, poziomo);
                przycisk.Clicked += kliknięciePolaPlanszy;
                plansza[pionowo, poziomo] = przycisk;
            }

        lvListaRuchówZielony.ItemsSource = listaRuchówZielony;
        lvListaRuchówBrązowy.ItemsSource = listaRuchówBrązowy;

        uzgodnijZawartośćPlanszy();

#if ANDROID
        btnLiczbaGraczy.Text = graPrzeciwkoKomputerowi ? "2 graczy" : "1 gracz";
#endif

        //testy
        //silnik.PołóżKamień(new WspółrzędnePola(2, 4));
        //silnik.PołóżKamień(new WspółrzędnePola(4, 5));
        //uzgodnijZawartośćPlanszy();
    }

    private bool ułożeniePionowe = false;

    protected override void OnSizeAllocated(double width, double height)
    {
        base.OnSizeAllocated(width, height);
        if (!ułożeniePionowe && (height > width))
        {
            ułożeniePionowe = true;
            grUkład.ColumnDefinitions = new ColumnDefinitionCollection(new ColumnDefinition());
            RowDefinition row1 = new RowDefinition()
            {
                Height = new GridLength(2, GridUnitType.Star)
            };
            RowDefinition row2 = new RowDefinition()
            {
                Height = new GridLength(1, GridUnitType.Star)
            };
            grUkład.RowDefinitions = new RowDefinitionCollection(row1, row2);
            Grid.SetRow(grPanel, 1);
            Grid.SetColumn(grPanel, 0);
        }
        if (ułożeniePionowe && (height < width))
        {
            ułożeniePionowe = false;
            ColumnDefinition col1 = new ColumnDefinition()
            {
                Width = new GridLength(2, GridUnitType.Star)
            };
            ColumnDefinition col2 = new ColumnDefinition()
            {
                Width = new GridLength(1, GridUnitType.Star)
            };
            grUkład.ColumnDefinitions = new ColumnDefinitionCollection(col1, col2);
            grUkład.RowDefinitions = new RowDefinitionCollection(new RowDefinition());
            Grid.SetRow(grPanel, 0);
            Grid.SetColumn(grPanel, 1);
        }
    }

    private WspółrzędnePola ustalWspółrzędnePola(Button button)
    {
        for (int poziomo = 0; poziomo < silnik.SzerokośćPlanszy; poziomo++)
            for (int pionowo = 0; pionowo < silnik.WysokośćPlanszy; pionowo++)
                if (button == plansza[poziomo, pionowo])
                    return new WspółrzędnePola(poziomo, pionowo);
        throw new Exception("To niemożliwe!");
    }

    private void kliknięciePolaPlanszy(object sender, EventArgs e)
    {
        if (e != null && graPrzeciwkoKomputerowi && silnik.NumerGraczaWykonującegoNastępnyRuch == 2) return;

        Button klikniętyPrzycisk = sender as Button;
        WspółrzędnePola współrzędnePola = ustalWspółrzędnePola(klikniętyPrzycisk);

        //wykonanie ruchu
        int zapamiętanyNumerGracza = silnik.NumerGraczaWykonującegoNastępnyRuch;
        if (silnik.PołóżKamień(współrzędnePola))
        {
            uzgodnijZawartośćPlanszy();
            aktualizujHistorięRuchów(współrzędnePola, zapamiętanyNumerGracza);
            bool koniecGry = zareagujNaSytuacjeSpecjalne();
            if (!koniecGry)
            {
                if (graPrzeciwkoKomputerowi && silnik.NumerGraczaWykonującegoNastępnyRuch == 2)
                {
                    //wykonajNajlepszyRuch();
                    Task.Delay(1000).ContinueWith((Task t) => this.Dispatcher.Dispatch(() => wykonajNajlepszyRuch()));
                }
            }
        }
    }

    private ObservableCollection<string> listaRuchówZielony = new ObservableCollection<string>();
    private ObservableCollection<string> listaRuchówBrązowy = new ObservableCollection<string>();

    private void aktualizujHistorięRuchów(WspółrzędnePola współrzędnePola,
                                          int zapamiętanyNumerGracza)
    {
        switch (zapamiętanyNumerGracza)
        {
            case 1:
                listaRuchówZielony.Add(współrzędnePola.SymbolPola);
                break;

            case 2:
                listaRuchówBrązowy.Add(współrzędnePola.SymbolPola);
                break;
        }
    }

    private void przygotowaniePlanszyDoNowejGry(int numerGraczaRozpoczynającego,
                                   int szerokośćPlanszy = 8, int wysokośćPlanszy = 8)
    {
        silnik = new ReversiSilnikAI(numerGraczaRozpoczynającego,
                                     szerokośćPlanszy, wysokośćPlanszy);
        try //!!!
        {
            listaRuchówZielony.Clear();
            listaRuchówBrązowy.Clear();
        }
        catch { }
        uzgodnijZawartośćPlanszy();
        grPlansza.IsEnabled = true;
        btnKolorGracza.IsEnabled = true;
    }

    private async void pokażKomunikat(string komunikat)
    {
        await DisplayAlert(Title, komunikat, "OK");
    }

    private async Task<bool> zadajPytanie(string pytanie)
    {
        bool odpowiedź = await DisplayAlert(Title, pytanie, "Tak", "Nie");
        return odpowiedź;
    }

    private bool zareagujNaSytuacjeSpecjalne()
    {
        //sytuacje specjalne
        ReversiSilnik.ReversiSilnik.SytuacjaNaPlanszy sytuacjaNaPlanszy = silnik.ZbadajSytuacjęNaPlanszy();
        bool koniecGry = false;
        switch (sytuacjaNaPlanszy)
        {
            case ReversiSilnik.ReversiSilnik.SytuacjaNaPlanszy.BieżącyGraczNieMożeWykonaćRuchu:
                pokażKomunikat("Gracz " + nazwyGraczy[silnik.NumerGraczaWykonującegoNastępnyRuch] + " zmuszony jest do oddania ruchu");
                silnik.Pasuj();
                uzgodnijZawartośćPlanszy();
                break;

            case ReversiSilnik.ReversiSilnik.SytuacjaNaPlanszy.ObajGraczeNieMogąWykonaćRuchu:
                pokażKomunikat("Obaj gracze nie mogą wykonać ruchu");
                koniecGry = true;
                break;

            case ReversiSilnik.ReversiSilnik.SytuacjaNaPlanszy.WszystkiePolaPlanszySąZajęte:
                koniecGry = true;
                break;
        }

        //koniec gry — informacja o wyniku
        if (koniecGry)
        {
            int numerZwycięzcy = silnik.NumerGraczaMającegoPrzewagę;
            if (numerZwycięzcy != 0)
                pokażKomunikat("Wygrał gracz " + nazwyGraczy[numerZwycięzcy]);
            else pokażKomunikat("Remis");

            Task<bool> t = zadajPytanie("Czy rozpocząć grę od nowa?");
            t.ContinueWith(
                (Task<bool> _t) =>
                {
                    if (_t.Result)
                    {
                        Dispatcher.Dispatch(
                            () =>
                            {
                                przygotowaniePlanszyDoNowejGry(
                                    1, silnik.SzerokośćPlanszy, silnik.WysokośćPlanszy);
                            });
                    }
                    else
                    {
                        Dispatcher.Dispatch(() =>
                        {
                            grPlansza.IsEnabled = false;
                            btnKolorGracza.IsEnabled = false;
                        });
                    }
                });
        }
        return koniecGry;
    }

    private WspółrzędnePola? ustalNajlepszyRuch()
    {
        if (!grPlansza.IsEnabled) return null;

        if (silnik.LiczbaPustychPól == 0)
        {
            pokażKomunikat("Nie ma już wolnych pól na planszy");
            return null;
        }

        try
        {
            return silnik.ProponujNajlepszyRuch();
        }
        catch
        {
            pokażKomunikat("Bieżący gracz nie może wykonać ruchu");
            return null;
        }
    }

    private void zaznaczNajlepszyRuch()
    {
        WspółrzędnePola? współrzędnePola = ustalNajlepszyRuch();
        if (współrzędnePola.HasValue)
        {
            Color kolorPodpowiedzi =
                kolory[silnik.NumerGraczaWykonującegoNastępnyRuch].Lerp(kolory[0], 0.5);
            plansza[współrzędnePola.Value.Poziomo,
                    współrzędnePola.Value.Pionowo].BackgroundColor = kolorPodpowiedzi;
        }
    }

    private void wykonajNajlepszyRuch()
    {
        WspółrzędnePola? współrzędnePola = ustalNajlepszyRuch();
        if (współrzędnePola.HasValue)
        {
            Button przycisk = plansza[współrzędnePola.Value.Poziomo,
                                      współrzędnePola.Value.Pionowo];
            kliknięciePolaPlanszy(przycisk, null);
        }
    }

    private void btnKolorGracza_Clicked(object sender, EventArgs e)
    {
        zaznaczNajlepszyRuch();
        //wykonajNajlepszyRuch();
    }

    private void btnLiczbaGraczy_Clicked(object sender, EventArgs e)
    {
        graPrzeciwkoKomputerowi = !graPrzeciwkoKomputerowi;
        Title = graPrzeciwkoKomputerowi ? "Reversi (1 gracz)" : "Reversi (2 graczy)";
        btnLiczbaGraczy.Text =
            graPrzeciwkoKomputerowi ? "Gra dla dwóch graczy" : "Gra z komputerem";
#if ANDROID
        btnLiczbaGraczy.Text = graPrzeciwkoKomputerowi ? "2 graczy" : "1 gracz";
#endif
        przygotowaniePlanszyDoNowejGry(1, silnik.SzerokośćPlanszy, silnik.WysokośćPlanszy);
    }
}