﻿using System.Text;

namespace Sensory
{
    public partial class MainPage : ContentPage
    {
        public MainPage()
        {
            InitializeComponent();

            pokażInformacjeOUrządzeniu();
            pokażInformacjeOWyświetlaczu();
            aktualizacjaInformacjiOStanieBaterii(this,
                new BatteryInfoChangedEventArgs(
                    Battery.Default.ChargeLevel,
                    Battery.Default.State,
                    Battery.Default.PowerSource));

            swAkcelerometr.IsEnabled = Accelerometer.Default.IsSupported;
        }

        private void pokażInformacjeOUrządzeniu()
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendLine("Informacje o urządzeniu:");
            sb.AppendLine($"Model: {DeviceInfo.Current.Model}");
            sb.AppendLine($"Producent: {DeviceInfo.Current.Manufacturer}");
            sb.AppendLine($"Nazwa: {DeviceInfo.Current.Name}");
            sb.AppendLine($"Idiom: {DeviceInfo.Current.Idiom}");
            sb.AppendLine($"Typ urządzenia: {((DeviceInfo.Current.DeviceType == DeviceType.Virtual)?"wirtualny":"rzeczywisty")}");
            lbUrządzenie.Text = sb.ToString();
        }

        private void ContentPage_Loaded(object sender, EventArgs e)
        {
            DeviceDisplay.Current.MainDisplayInfoChanged +=
                (object sender, DisplayInfoChangedEventArgs e) =>
                {
                    pokażInformacjeOWyświetlaczu();
                };
        }

        private void pokażInformacjeOWyświetlaczu()
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendLine("Informacje o wyświetlaczu:");
            sb.AppendLine($"Rozdzielczość: {DeviceDisplay.Current.MainDisplayInfo.Width} x {DeviceDisplay.Current.MainDisplayInfo.Height} px");
            sb.AppendLine($"DPI: {DeviceDisplay.Current.MainDisplayInfo.Density}");
            sb.AppendLine($"Orientacja: {DeviceDisplay.Current.MainDisplayInfo.Orientation}");
            lbEkran.Text = sb.ToString();
        }

        private void włączenieObserwacjiStanuBaterii(object sender, ToggledEventArgs e)
        {
            try
            {
                if (swObseracjaStanuBaterii.IsToggled)
                {
                    Battery.Default.BatteryInfoChanged += aktualizacjaInformacjiOStanieBaterii;
                }
                else
                    Battery.Default.BatteryInfoChanged -= aktualizacjaInformacjiOStanieBaterii;
            }
            catch (Exception exc)
            {
                lbBateriaStan.Text = "Błąd: " + exc.Message;
            }
        }

        private void aktualizacjaInformacjiOStanieBaterii(object sender, BatteryInfoChangedEventArgs e)
        {
            try
            {
                lbBateriaStan.Text = "Stan baterii: " + e.State switch
                {
                    BatteryState.Discharging => "Rozładowywanie",
                    BatteryState.Charging => "Ładowanie",
                    BatteryState.NotCharging => "Problem z ładowaniem",
                    BatteryState.Full => "Pełna",
                    BatteryState.NotPresent => "Nieobecna",
                    BatteryState.Unknown => "Nieznany",
                    _ => "Nierozpoznany"
                };
                lbBateriaPoziom.Text = $"Poziom naładowania baterii {100*e.ChargeLevel}%";
                pbBateriaPoziom.Progress = e.ChargeLevel;
            }
            catch (Exception exc)
            {
                lbBateriaStan.Text = "Błąd: " + exc.Message;
            }
        }

        private void Switch_Toggled(object sender, ToggledEventArgs e)
        {
            if (Accelerometer.Default.IsSupported)
            {
                if (!Accelerometer.Default.IsMonitoring)
                {
                    Accelerometer.ReadingChanged += pokażOdczytAkcelerometru;
                    Accelerometer.ShakeDetected += sygnalizujPotrząsanie;
                    Accelerometer.Start(SensorSpeed.UI);
                }
                else
                {
                    Accelerometer.Stop();
                    Accelerometer.ReadingChanged -= pokażOdczytAkcelerometru;
                    Accelerometer.ShakeDetected -= sygnalizujPotrząsanie;
                }
            }
        }

        private void pokażOdczytAkcelerometru(object? sender, AccelerometerChangedEventArgs e)
        {
            lbAkcelerometr.Text = $"Kierunek przypieszenia ziemskiego:\n\tX = {e.Reading.Acceleration.X}\n\tY = {e.Reading.Acceleration.Y}\n\tZ = {e.Reading.Acceleration.Z}\n\tDługość = {e.Reading.Acceleration.Length()}";
            pbPrzyspieszenie.Progress = e.Reading.Acceleration.Length() / 3;
            if (DateTime.Now > czasPotrząśnięcia.AddSeconds(3)) lbPotrząsanie.Text = "---";
        }

        private DateTime czasPotrząśnięcia;

        private void sygnalizujPotrząsanie(object? sender, EventArgs e)
        {
            lbPotrząsanie.Text = "Wykryto potrząsanie urządzeniem";
            Button_Clicked(this, EventArgs.Empty);
            czasPotrząśnięcia = DateTime.Now;

        }

        private bool czyLatarkaWłączona = false;

        private async void Button_Clicked(object sender, EventArgs e)
        {
            try
            {
                if (!czyLatarkaWłączona)
                {
                    Flashlight.Default.TurnOnAsync();
                }
                else
                {
                    Flashlight.Default.TurnOffAsync();
                }
                Vibration.Default.Vibrate(TimeSpan.FromMilliseconds(300));
                czyLatarkaWłączona = !czyLatarkaWłączona;
            }
            catch (FeatureNotSupportedException exc)
            {
                await DisplayAlert(Title, "Nie ma latarki lub wibratora", "OK");
            }
            catch (PermissionException exc)
            {
                await DisplayAlert(Title, "Brak uprawnień", "OK");
            }
            catch(Exception exc)
            {
                await DisplayAlert(Title, exc.Message, "OK");
            }
        }
    }

}
