﻿using System.Text;

namespace Sensory
{
    public partial class MainPage : ContentPage
    {
        public MainPage()
        {
            InitializeComponent();

            pokażInformacjeOUrządzeniu();
            pokażInformacjeOWyświetlaczu();
        }

        private void pokażInformacjeOUrządzeniu()
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendLine("Informacje o urządzeniu:");
            sb.AppendLine($"Model: {DeviceInfo.Current.Model}");
            sb.AppendLine($"Producent: {DeviceInfo.Current.Manufacturer}");
            sb.AppendLine($"Nazwa: {DeviceInfo.Current.Name}");
            sb.AppendLine($"Idiom: {DeviceInfo.Current.Idiom}");
            sb.AppendLine($"Typ urządzenia: {((DeviceInfo.Current.DeviceType == DeviceType.Virtual)?"wirtualny":"rzeczywisty")}");
            lbUrządzenie.Text = sb.ToString();
        }

        private void ContentPage_Loaded(object sender, EventArgs e)
        {
            DeviceDisplay.Current.MainDisplayInfoChanged +=
                (object sender, DisplayInfoChangedEventArgs e) =>
                {
                    pokażInformacjeOWyświetlaczu();
                };
        }

        private void pokażInformacjeOWyświetlaczu()
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendLine("Informacje o wyświetlaczu:");
            sb.AppendLine($"Rozdzielczość: {DeviceDisplay.Current.MainDisplayInfo.Width} x {DeviceDisplay.Current.MainDisplayInfo.Height} px");
            sb.AppendLine($"DPI: {DeviceDisplay.Current.MainDisplayInfo.Density}");
            sb.AppendLine($"Orientacja: {DeviceDisplay.Current.MainDisplayInfo.Orientation}");
            lbEkran.Text = sb.ToString();
        }
    }

}
