﻿using System.Windows.Input;

namespace PierwszaAplikacjaMAUI
{
    public class WykonaniePoleceniaPrzyZamknięciuStrony : Behavior<Page>
    {
        protected override void OnAttachedTo(Page page)
        {
            base.OnAttachedTo(page);
            this.BindingContext = page.BindingContext;
            page.Disappearing += page_Disappearing;
        }

        private void page_Disappearing(object? sender, EventArgs e)
        {
            if(Command != null && Command.CanExecute(CommandParameter))
                Command.Execute(CommandParameter);
        }

        #region Command1
        public static readonly BindableProperty CommandProperty =
            BindableProperty.Create(
                "Command",
                typeof(ICommand),
                typeof(WykonaniePoleceniaPrzyZamknięciuStrony),
                null,
                BindingMode.TwoWay);

        public ICommand Command
        {
            get { return (ICommand)GetValue(CommandProperty); }
            set { SetValue(CommandProperty, value); }
        }

        public static readonly BindableProperty CommandParameterProperty =
            BindableProperty.Create(
                nameof(CommandParameter),
                typeof(object),
                typeof(WykonaniePoleceniaPrzyZamknięciuStrony),
                null,
                BindingMode.TwoWay);

        public object CommandParameter
        {
            get { return GetValue(CommandParameterProperty); }
            set { SetValue(CommandParameterProperty, value); }
        }
        #endregion
    }
}
