﻿using Microsoft.Maui.Controls.Shapes;
using System.Globalization;

namespace PierwszaAplikacjaMAUI
{
    public class ByteToDoubleConverter : IValueConverter
    {
        public object? Convert(object? value, Type targetType, object? parameter, CultureInfo culture)
        {
            byte b = (byte)value;
            return (double)b/255.0;
        }

        public object? ConvertBack(object? value, Type targetType, object? parameter, CultureInfo culture)
        {
            double d = (double)value;
            return (byte)Math.Round(d * 255);            
        }
    }

    public class RGBToColor : IMultiValueConverter
    {
        public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
        {
            if (values == null || values.Any(v => v == null)) return Colors.Black;
            byte r = (byte)values[0];
            byte g = (byte)values[1];
            byte b = (byte)values[2];
            return Color.FromRgb(r, g, b);
        }

        public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
