﻿namespace Zachowania
{
    public class PrzyciskZLicznikiem : Behavior<Button>
    {
        public int Licznik { get; set; } = 0;

        protected override void OnAttachedTo(Button button)
        {
            base.OnAttachedTo(button);
            if (button != null)
            {
                button.Clicked += button_Clicked;
            }
        }

        protected override void OnDetachingFrom(Button button)
        {
            base.OnDetachingFrom(button);
            button.Clicked -= button_Clicked;
        }

        private void button_Clicked(object? sender, EventArgs e)
        {
            Licznik++;            
            Button button = sender as Button;
            button.Text = Licznik.ToString();
        }
    }

    public class PrzyciskZmieniającyTło : Behavior<VisualElement>
    {
        private VisualElement visualElement { get; set; } = null;

        protected override void OnAttachedTo(VisualElement bindable)
        {
            base.OnAttachedTo(bindable);
            this.visualElement = bindable;
        }

        public static readonly BindableProperty PrzyciskProperty =
            BindableProperty.Create(
                nameof(Przycisk),
                typeof(Button),
                typeof(PrzyciskZmieniającyTło),
                null,
                BindingMode.OneWay,
                null,
                przyciskZmieniony);

        public Button Przycisk 
        { 
            get
            {
                return (Button)GetValue(PrzyciskProperty);
            }
            set
            {
                SetValue(PrzyciskProperty, value);
            }
        }

        public Brush Kolor { get; set; } = Brush.Pink;

        private static void przyciskZmieniony(BindableObject bindable, object oldValue, object newValue)
        {
            EventHandler przyciskZmieniającyTło_Clicked =
                (object? sender, EventArgs e) =>
                {
                    PrzyciskZmieniającyTło b = bindable as PrzyciskZmieniającyTło;
                    if (b.visualElement != null) b.visualElement.Background = b.Kolor;
                };

            if (oldValue != null) ((Button)oldValue).Clicked -= przyciskZmieniającyTło_Clicked;
            if (newValue != null) ((Button)newValue).Clicked += przyciskZmieniającyTło_Clicked;
        }
    }
}
