﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace PierwszaAplikacjaMAUI.Model
{
    //DAL
    internal static class KolorHelper
    {
        private readonly static string ścieżkaPliku = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.UserProfile), "kolor.xml");
        private readonly static IFormatProvider fp = new System.Globalization.CultureInfo("pl-PL");

        public static void ZapiszStanDoPliku(this Kolor kolor)
        {
            XDocument xml = new XDocument(
                new XComment("Data zapisu: " + DateTime.Now.ToString(fp)),
                new XElement("Kolor",
                    new XElement("R", kolor.R.ToString(fp)),
                    new XElement("G", kolor.G.ToString(fp)),
                    new XElement("B", kolor.B.ToString(fp))
                )
            );
            xml.Save(ścieżkaPliku);
        }

        //pseudokonstruktor
        public static Kolor OdczytajStanZPliku()
        {
            try
            {
                XDocument xml = XDocument.Load(ścieżkaPliku);
                byte r = byte.Parse(xml.Root.Element("R").Value, fp);
                byte g = byte.Parse(xml.Root.Element("G").Value, fp);
                byte b = byte.Parse(xml.Root.Element("B").Value, fp);
                return new Kolor(r, g, b);
            }
            catch
            {
                return Kolor.Czerń;
            }
        }
    }
}
