﻿using PierwszaAplikacjaMAUI.Model;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PierwszaAplikacjaMAUI.ModelWidoku
{
    internal class EdycjaKoloru : INotifyPropertyChanged
    {
        private Kolor model = KolorHelper.OdczytajStanZPliku();

        public byte R
        {
            get
            {
                return model.R;
            }
            set
            {
                model.R = value;
                onPropertyChanged(nameof(R));
            }
        }

        public byte G
        {
            get
            {
                return model.G;
            }
            set
            {
                model.G = value;
                onPropertyChanged(nameof(G));
            }
        }

        public byte B
        {
            get
            {
                return model.B;
            }
            set
            {
                model.B = value;
                onPropertyChanged(nameof(B));
            }
        }

        public event PropertyChangedEventHandler? PropertyChanged;

        private void onPropertyChanged(string propertyName)
        {
            if(PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
        }

        //tymczasowe
        public Microsoft.Maui.Graphics.Color Kolor
        {
            get
            {
                return new Microsoft.Maui.Graphics.Color(R, G, B);
            }
        }
    }
}
