﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;
using System.Collections.Generic;
using SQLiteDatabase.DBModel;

namespace SQLiteDatabase
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        private void ShowPeople(DBModel.Person[] people)
        {
            string s = "Osoby:";
            foreach (var person in people)
            {
                s += "\n" + person.ToString();
            }
            
            TextView tv = FindViewById<TextView>(Resource.Id.textView);
            tv.Text = s;
        }

        private void ShowBooks(Book[] books)
        {
            string s = "Książki:";
            foreach (var book in books)
            {
                s += "\n" + book.ToString();
            }

            TextView tv = FindViewById<TextView>(Resource.Id.textView2);
            tv.Text = s;
        }

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            Xamarin.Essentials.Platform.Init(this, savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);
            UseGenericDatabase();
        }

        private void UseGenericDatabase()
        {
            string dbName = "generic.db";

            this.DeleteDatabase(dbName);

            var db = new GenericDatabase(this, dbName);
            db.RegisterType<DBModel.Person>();
            db.RegisterType<Book>();

            ManipulatePeopleRecords(db);            
            ManipulateBooksRecords(db);
        }

        private void ManipulateBooksRecords(GenericDatabase db)
        {
            db.AddRecord(new Book(1, "Książka1", "Autor1", 123, 12));
            db.AddRecord(new Book(2, "Książka2", "Autor2", 60, 5));
            db.AddRecord(new Book(3, "Książka3", "Autor3", 542, 23));
            var books = db.GetAllRecords<Book>("Id asc");
            ShowBooks(books);

            db.DeleteRecord<Book>(2);
            books = db.GetAllRecords<Book>("Id asc");
            ShowBooks(books);

            db.UpdateRecord(1, new Book(7, "Nowa książka", "Nowy autor", 999, 13));
            books = db.GetAllRecords<Book>("Id asc");
            ShowBooks(books);
        }

        private void ManipulatePeopleRecords(GenericDatabase db)
        {
            db.AddRecord(new DBModel.Person(1, "Jan", "Kowalski", 47, 123421));
            db.AddRecord(new DBModel.Person(2, "John", "Smith", 36, 43654));
            db.AddRecord(new DBModel.Person(3, "Hans", "Muller", 32, 5646456));

            DBModel.Person[] people = db.GetAllRecords<DBModel.Person>("Age desc");
            ShowPeople(people);

            db.DeleteRecord<DBModel.Person>(2);
            people = db.GetAllRecords<DBModel.Person>("Age desc");
            ShowPeople(people);

            db.UpdateRecord(1, new DBModel.Person(4, "Jean", "Dupont", 23, 3454355));
            people = db.GetAllRecords<DBModel.Person>("Age desc");
            ShowPeople(people);
        }

        private void UsePeopleDatabase()
        {
            //usunięcie
            this.DeleteDatabase(PeopleDatabase.DBName);

            //tworzenie
            PeopleDatabase db = new PeopleDatabase(this);
            db.AddRecord(new DBModel.Person(1, "Jan", "Kowalski", 47, 123421));
            db.AddRecord(new DBModel.Person(2, "John", "Smith", 36, 43654));
            db.AddRecord(new DBModel.Person(3, "Hans", "Muller", 32, 5646456));

            DBModel.Person[] people = db.GetAllRecords("Age desc");
            ShowPeople(people);

            db.DeleteRecord(2);
            people = db.GetAllRecords("Age desc");
            ShowPeople(people);

            db.UpdateRecord(1, new DBModel.Person(4, "Jean", "Dupont", 23, 3454355));
            people = db.GetAllRecords("Age desc");
            ShowPeople(people);
        }

        public override void OnRequestPermissionsResult(int requestCode, string[] permissions, [GeneratedEnum] Android.Content.PM.Permission[] grantResults)
        {
            Xamarin.Essentials.Platform.OnRequestPermissionsResult(requestCode, permissions, grantResults);

            base.OnRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }
}