﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;

namespace SQLiteDatabase.DBModel
{
    public class Table<T> : ITable
        where T : IClassTable
    {
        public string TableName { get; }
        public string[] TableColumnNames { get; }
        public string[] TableColumnProperties { get; }

        private static readonly Dictionary<Type, string> _toSQliteTypesDict = new Dictionary<Type, string>()
        {
            { typeof(int), "INTEGER" },
            { typeof(string), "TEXT" },
        };

        public Table()
        {
            Type type = typeof(T);
            TableName = type.Name;
            var properties = type.GetProperties();
            TableColumnNames = new string[properties.Length];
            TableColumnProperties = new string[properties.Length];

            for (int i = 0; i < properties.Length; i++)
            {
                var property = properties[i];
                TableColumnNames[i] = property.Name;
                TableColumnProperties[i] = _toSQliteTypesDict[property.PropertyType];
            }
        }
    }
}