﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;

namespace SQLiteDatabase.DBModel
{
    public class Person : IClassTable
    {
        public const string TableName = "person";
        public static readonly string[] TableColumnNames = { "Id", "FirstName", "LastName", "Age", "PhoneNumber" };
        public static readonly string[] TableColumnProperties = { "INTEGER PRIMARY KEY", "TEXT", "TEXT", "INTEGER", "INTEGER" };

        public int Id { get; set; }
        public string FirstName { get; set; }
        public string LastName { get; set; }
        public int Age { get; set; }
        public int PhoneNumber { get; set; }

        public Person()
        {

        }

        public Person(int id, string firstName, string lastName, int age, int phoneNumber)
        {
            Id = id;
            FirstName = firstName;
            LastName = lastName;
            Age = age;
            PhoneNumber = phoneNumber;
        }

        public override string ToString()
        {
            return "(" + Id.ToString() + ") " + FirstName + " " + LastName + " (" + Age + "), tel. " + PhoneNumber.ToString();
        }
    }
}