﻿using Android.App;
using Android.Content;
using Android.Media;
using Android.OS;
using Android.Widget;

namespace Uslugi
{
    [Service]
    class Usluga : Service
    {
        public static bool czyUtworzona;
        public override IBinder OnBind(Intent intent)
        {
            return null;
        }

        private Java.Util.Timer timer;

        private const int IdPowiadomienia = 111;
        private const string KanalPowiadomienia = "kanalUslugi";

        class Zadanie : Java.Util.TimerTask
        {
            static ToneGenerator tg = new ToneGenerator(Stream.Alarm, 100);
            public override void Run()
            {
                tg.StartTone(Tone.CdmaAlertCallGuard, 200);
                //string czas = DateTime.Now.ToLongTimeString();
                //toastDlaTimera.SetText("Usluga: " + czas);
                //toastDlaTimera.Show();
            }
        }

        public override void OnCreate()
        {
            base.OnCreate();

            Intent i = new Intent(this, typeof(MainActivity));
            PendingIntent pi = PendingIntent.GetActivity(this, 0, i, 0);

            Notification.Builder nb = null;
            Notification powiadomienie = null;

            if (Build.VERSION.SdkInt >= BuildVersionCodes.O)
            {
                NotificationManager nm = (NotificationManager)GetSystemService(NotificationService);
                nm.CreateNotificationChannel(new NotificationChannel(KanalPowiadomienia, KanalPowiadomienia, NotificationImportance.Low));
                nb = new Notification.Builder(this, KanalPowiadomienia);
            }
            else
            {
                nb = new Notification.Builder(this);
            }

            nb.SetContentTitle("Usluga");
            nb.SetContentText("Usluga nadal dziala. Wylacz ja z poziomu aplikacji.");
            nb.SetContentIntent(pi);
            nb.SetSmallIcon(Resource.Mipmap.ic_launcher_foreground);

            powiadomienie = nb.Build();

            StartForeground(IdPowiadomienia, powiadomienie);

            timer = new Java.Util.Timer();
            timer.ScheduleAtFixedRate(new Zadanie(), 1000, 2000);

            Toast.MakeText(this, "Usluga utworzona - onCreate", ToastLength.Short).Show();

            czyUtworzona = true;
        }

        public override void OnDestroy()
        {
            timer.Cancel();

            StopForeground(true);

            Toast.MakeText(this, "Usluga zatrzymana - onCreate", ToastLength.Short).Show();

            czyUtworzona = false;

            base.OnDestroy();
        }

        public override StartCommandResult OnStartCommand(Intent intent, StartCommandFlags flags, int startId)
        {
            Toast.MakeText(this, "Usluga uruchomiona - StartCommand", ToastLength.Short).Show();

            return base.OnStartCommand(intent, flags, startId);
        }
    }
}